package cn.sexycode.springo.form.model;

public interface FormType {

    enum Type implements FormType {

        /**
         *
         */
        PC("pc"),
        /**
         *
         */
        MOBILE("mobile");

        private final String value;

        Type(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static FormType fromValue(String v) {
            for (Type c : Type.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }
    }
}
