package cn.sexycode.springo.form.model;


import cn.sexycode.springo.core.data.db.model.BaseModel;
import lombok.Getter;
import lombok.Setter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;


/**
 * <pre>
 * 描述：BPM_FORM_RIGHT 实体对象
 * </pre>
 */
public class FormRight extends BaseModel {

    /**
     * 主键
     */
    @XmlAttribute(name = "id")
    @Getter
    @Setter
    protected String id;

    /**
     * form_key_
     */
    @XmlAttribute(name = "formKey")
    @Getter
    @Setter
    protected String formKey;

    /**
     * 流程key
     */
    @Getter
    @Setter
    @XmlAttribute(name = "flowKey")
    protected String flowKey;

    /**
     * 节点ID
     */
    @Getter
    @Setter
    @XmlAttribute(name = "nodeId")
    protected String nodeId;

    /**
     * 父流程定义
     */
    @Getter
    @Setter
    @XmlAttribute(name = "parentFlowKey")
    protected String parentFlowKey;

    /**
     * 权限字段
     */
    @Getter
    @Setter
    @XmlElement(name = "permission")
    protected String permission;

    /**
     * 权限类型 1 流程权限，2 实例权限
     */
    @Getter
    @Setter
    @XmlAttribute(name = "permissionType")
    protected int permissionType = 0;

}