package cn.sexycode.springo.form.model;


import cn.sexycode.springo.core.data.db.model.BaseModel;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;


/**
 * <pre>
 * 描述：流程表单HTML设计历史记录 实体对象
 * </pre>
 * @author qzz
 */
@TableName("form_hi")
public class FormHistory extends BaseModel {
    /**
     *
     */
    private static final long serialVersionUID = 1L;
    /**
     * 对应表单ID
     */
    @Getter
    @Setter
    protected String formId;
    /**
     * 表单名称
     */
    @Getter
    @Setter
    protected String name;
    /**
     * 表单描述
     */
    @Getter
    @Setter
    protected String description;
    /**
     * 表单设计（HTML代码）
     */
    @Getter
    @Setter
    protected String formHtml;

    @Getter
    @Setter
    protected String formKey;
    @Getter
    @Setter
    protected int formVersion;

    public FormHistory() {
    }

    public FormHistory(IForm form) {
        this.setId(form.getId());
        this.formId = form.getId();
        this.name = form.getName();
        this.description = form.getDescription();
        this.formHtml = form.getFormHtml();
        this.formKey = form.getFormKey();
        this.formVersion = form.getFormVersion();
    }

}