package cn.sexycode.springo.form.model;


import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.model.BaseModel;
import lombok.Getter;
import lombok.Setter;

/**
 * 对象功能:用户任务表单字段信息表 entity对象
 *
 * @author qinzaizhen
 */
public class FormField extends BaseModel {


    private static final long serialVersionUID = 1L;


    /**
     * 字段名称
     */
    @Getter
    @Setter
    private String name;

    /**
     * 字段描述
     */
    @Getter
    @Setter
    private String description;

    /**字段的类型*/
    @Getter
    @Setter
    private FormFiledType type;

    /**分组ID*/
    @Getter
    @Setter
    private String groupId = "0";

    /**表单ID*/
    @Getter
    @Setter
    private String formId;

    /**bo定义ID*/
    @Getter
    @Setter
    private String boDefId;

    /**表ID*/
    @Getter
    @Setter
    private String entId;

    /**BO属性ID*/
    @Getter
    @Setter
    private String boAttrId;

    /**运算表达式*/
    @Getter
    @Setter
    private String calculation;

    /**控件类型*/
    @Getter
    @Setter
    private String ctrlType;

    /**验证规则*/
    @Setter
    private String validRule;

    /**选项*/
    @Getter
    @Setter
    private String options;

    /**排序*/
    @Getter
    @Setter
    private Integer sn;

    /**
     * 映射对应的实体名称。
     */
    @Getter
    @Setter
    private String entName;


    /**
     * 返回 验证规则
     *
     * @return String 验证规则
     */
    public String getValidRule() {
        if (StringUtil.isEmpty(validRule)) {
            return "{}";
        }
        return this.validRule;
    }

}