package cn.sexycode.springo.form.model;

import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.core.data.db.model.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import lombok.Getter;
import lombok.Setter;

import java.util.ArrayList;
import java.util.List;

/**
 * 对象功能:表单元数据
 *
 * @author qinzaizhen
 */
public class FormDef extends BaseModel {

    private static final long serialVersionUID = 1L;
    @Getter
    @Setter
    private String defKey;
    /**
     * 表单名字
     */
    @Getter
    @Setter
    private String name;
    /**
     * 类型
     */
    @Getter
    @Setter
    private String type;
    /**
     类型Id
     */
    @Getter
    @Setter
    private String typeId;
    /**表单名字*/
    @Getter
    @Setter
    private String description;
    /**
     * 用户任务表单字段信息表列表
     * */
    @Getter
    @Setter
    @TableField(exist = false)
    private List<FormField> formFields = new ArrayList<>();
    @Getter
    @Setter
    private String expand;
    /**
     * 意见配置
     * [{"name": "jzyj","description": "局长意见"},{"name": "cwyj","description": "财务意见" }]
     */
    @Getter
    @Setter
    private String opinionConf;

    public FormDef() {
    }


    public JSONArray getFieldList() {
        JSONObject json = JSONObject.parseObject(this.expand);
        return json.getJSONArray("tables");
    }

}