package cn.sexycode.springo.form.model;

import cn.sexycode.springo.core.base.api.IEnum;

/**
 * @author qinzaizhen
 */
public interface FormCategory extends IEnum {
    enum Category implements FormCategory {
        /**
         *
         */
        INNER("inner"),
        /**
         *
         */
        FRAME("frame");

        private final String value;

        Category(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static FormCategory fromValue(String v) {
            for (Category c : Category.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }
    }
}
