package cn.sexycode.springo.form.model;


import cn.sexycode.springo.core.data.db.model.BaseModel;
import lombok.Getter;
import lombok.Setter;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;


/**
 * <pre>
 * 描述：form_bus_set 实体对象
 * </pre>
 */
public class FormBusSet extends BaseModel {

    /**
     * 主键
     */
    @Getter
    @Setter
    @XmlAttribute(name = "id")
    protected String id;

    /**
     * formKey
     */
    @Getter
    @Setter
    @XmlAttribute(name = "formKey")
    protected String formKey;

    /**
     * JavaScript前置脚本
     */
    @Getter
    @Setter
    @XmlElement(name = "jsPreScript")
    protected String jsPreScript;

    /**
     * JavaScript后置脚本
     */
    @Getter
    @Setter
    @XmlElement(name = "jsAfterScript")
    protected String jsAfterScript;

    /**
     * 保存前置脚本
     */
    @Getter
    @Setter
    @XmlElement(name = "preScript")
    protected String preScript;

    /**
     * 保存后置脚本
     */
    @Getter
    @Setter
    @XmlElement(name = "afterScript")
    protected String afterScript;

    /**
     * 展示前Java脚本
     */
    @Getter
    @Setter
    @XmlElement(name = "showScript")
    protected String showScript;

    /**
     * 是否树形列表
     */
    @Getter
    @Setter
    @XmlAttribute(name = "isTreeList")
    protected Short isTreeList;

    /**
     * {idKey:"idKEY名称",pIdKey:"",name:"显示名称",title,rootPid}
     */
    @Getter
    @Setter
    @XmlElement(name = "treeConf")
    protected String treeConf;

}