package cn.sexycode.springo.form.manager.impl;

import cn.sexycode.springo.core.base.core.util.AppUtil;
import cn.sexycode.springo.core.base.core.util.Dom4jUtil;
import cn.sexycode.springo.core.base.core.util.FileUtil;
import cn.sexycode.springo.core.data.db.id.UniqueIdUtil;
import cn.sexycode.springo.core.data.db.manager.impl.BaseManagerImpl;
import cn.sexycode.springo.form.dao.FormTemplateDao;
import cn.sexycode.springo.form.manager.FormTemplateManager;
import cn.sexycode.springo.form.model.FormTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.File;
import java.util.List;

@Service("bpmFormTemplateManager")
public class FormTemplateManagerImpl extends BaseManagerImpl<FormTemplate> implements FormTemplateManager {
    private static Log logger = LogFactory.getLog(FormTemplateManagerImpl.class);
    @Resource
    FormTemplateDao formTemplateDao;

    /**
     * 返回模版物理的路径。
     *
     * @return
     * @throws Exception
     */
    public static String getFormTemplatePath() throws Exception {
        return FileUtil.getClassesPath() + File.separator + "template" + File.separator + "form" + File.separator;
    }

    /**
     * 初始化模版，在系统启用的时候进行调用。
     */
    public static void initTemplate() {
        FormTemplateManager service = (FormTemplateManager) AppUtil.getBean(FormTemplateManager.class);
        try {
            service.init();
        } catch (Exception e) {
            logger.debug(e.getMessage());
        }
    }

    /**
     * 根据模版别名取得模版。
     *
     * @param alias
     * @return
     */
    @Override
    public FormTemplate getByTemplateAlias(String alias) {
        return formTemplateDao.getByTemplateAlias(alias);
    }

    /**
     * 获取所有的系统原始模板
     *
     * @throws Exception
     */
    @Override
    public void initAllTemplate() throws Exception {
        formTemplateDao.delSystem();
        addTemplate();
    }

    /**
     * 当模版数据为空时，将form目录下的模版添加到数据库中。
     */
    @Override
    public void init() throws Exception {
        Integer amount = formTemplateDao.getHasData();
        if (amount == 0) {
            addTemplate();
        }
    }

    /**
     * 初始化添加form下的模版数据到数据库。
     */
    private void addTemplate() throws Exception {
        String templatePath = getFormTemplatePath();
        String xml = FileUtil.readFile(templatePath + "templates.xml");
        Document document = Dom4jUtil.loadXml(xml);
        Element root = document.getRootElement();
        List<Element> list = root.elements();
        for (Element element : list) {
            String alias = element.attributeValue("alias");
            String name = element.attributeValue("name");
            String type = element.attributeValue("type");
            String templateDesc = element.attributeValue("templateDesc");
            String macroAlias = element.attributeValue("macroAlias");
            String dir = element.attributeValue("dir");

            String fileName = templatePath + dir + File.separator + alias + ".ftl";
            String html = FileUtil.readFile(fileName);

            FormTemplate formTemplate = new FormTemplate();
            formTemplate.setTemplateId(UniqueIdUtil.getSuid());
            formTemplate.setMacrotemplateAlias(macroAlias);
            formTemplate.setHtml(html);
            formTemplate.setTemplateName(name);
            formTemplate.setAlias(alias);
            formTemplate.setCanedit(0);
            formTemplate.setTemplateType(type);
            formTemplate.setTemplateDesc(templateDesc);
            formTemplateDao.insert(formTemplate);
        }
    }

    /**
     * 检查模板别名是否唯一
     *
     * @param alias
     * @return
     */
    @Override
    public boolean isExistAlias(String alias) {
        //todo
		/*List<FormTemplate> list=formTemplateDao.getAll();
		for(FormTemplate bpmFormTemplate:list){
			if(bpmFormTemplate.getAlias().equals(alias)){
				return true;
			}
		}*/
        return false;
    }


    /**
     * 将用户自定义模板备份
     *
     * @param id
     */
    @Override
    public void backUpTemplate(String id) {
        FormTemplate formTemplate = formTemplateDao.selectById(id);
        String alias = formTemplate.getAlias();
        String name = formTemplate.getTemplateName();
        String desc = formTemplate.getTemplateDesc();
        String html = formTemplate.getHtml();
        String type = formTemplate.getTemplateType();
        String macroAlias = formTemplate.getMacrotemplateAlias();

        String templatePath = null;
        try {
            templatePath = getFormTemplatePath();
        } catch (Exception e1) {
            e1.printStackTrace();
        }

        String xmlPath = templatePath + "templates.xml";
        String xml = FileUtil.readFile(xmlPath);

        Document document = Dom4jUtil.loadXml(xml);
        Element root = document.getRootElement();

        Element e = root.addElement("template");
        e.addAttribute("alias", alias);
        e.addAttribute("name", name);
        e.addAttribute("type", type);
        e.addAttribute("templateDesc", desc);
        e.addAttribute("macroAlias", macroAlias);
        String content = document.asXML();

        FileUtil.writeFile(xmlPath, content);
        FileUtil.writeFile(templatePath + alias + ".ftl", html);

        formTemplate.setCanedit(0);
        formTemplateDao.updateById(formTemplate);
    }

    /**
     * 根据模版类型取得模版列表。
     *
     * @param type
     * @return
     */
    @Override
    public List<FormTemplate> getTemplateType(String type) {
        return formTemplateDao.getTemplateType(type);
    }

    /**
     * 获取主表模版
     *
     * @return
     */
    @Override
    public List<FormTemplate> getAllMainTableTemplate(boolean isPC) {
        return getTemplateType(isPC ? FormTemplate.MAIN_TABLE : FormTemplate.MOBILE_MAIN);
    }

    /**
     * 获取子表模版。
     *
     * @return
     */
    @Override
    public List<FormTemplate> getAllSubTableTemplate(boolean isPC) {
        return getTemplateType(isPC ? FormTemplate.SUB_TABLE : FormTemplate.Mobile_SUB);
    }

    /**
     * 获取宏模版。
     *
     * @return
     */
    @Override
    public List<FormTemplate> getAllMacroTemplate() {
        return getTemplateType(FormTemplate.MACRO);
    }

    /**
     * 获取表管理模版。
     *
     * @return
     */
    @Override
    public List<FormTemplate> getAllTableManageTemplate() {
        return getTemplateType(FormTemplate.TABLE_MANAGE);
    }

    /**
     * 获取列表模版。
     *
     * @return
     */
    @Override
    public List<FormTemplate> getListTemplate() {
        return getTemplateType(FormTemplate.LIST);
    }

    /**
     * 获取明细模版。
     *
     * @return
     */
    @Override
    public List<FormTemplate> getDetailTemplate() {
        return getTemplateType(FormTemplate.DETAIL);
    }

    /**
     * 获取数据模版。
     *
     * @return
     */
    @Override
    public List<FormTemplate> getDataTemplate() {
        return getTemplateType(FormTemplate.DATA_TEMPLATE);
    }

    /**
     * 获取查询数据模版。
     *
     * @return
     */
    @Override
    public List<FormTemplate> getQueryDataTemplate() {
        return getTemplateType(FormTemplate.QUERY_DATA_TEMPLATE);
    }
}
