package cn.sexycode.springo.form.manager.impl;

import cn.sexycode.springo.bo.def.BoDefService;
import cn.sexycode.springo.bo.model.BaseBoDef;
import cn.sexycode.springo.bo.model.BaseBoEnt;
import cn.sexycode.springo.core.base.core.engine.freemark.FreemarkerEngine;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.core.base.core.util.JAXBUtil;
import cn.sexycode.springo.core.base.core.util.ThreadMsgUtil;
import cn.sexycode.springo.core.data.db.id.UniqueIdUtil;
import cn.sexycode.springo.core.data.db.manager.impl.BaseManagerImpl;
import cn.sexycode.springo.form.dao.*;
import cn.sexycode.springo.form.manager.FormHistoryManager;
import cn.sexycode.springo.form.manager.FormManager;
import cn.sexycode.springo.form.manager.FormTemplateManager;
import cn.sexycode.springo.form.model.*;
import cn.sexycode.springo.form.model.impl.Form;
import cn.sexycode.springo.form.util.FreeMakerUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author qinzaizhen
 */
@Service("bpmFormManager")
public class FormManagerImpl extends BaseManagerImpl<IForm> implements FormManager {
    @Resource
    FormDao formDao;
    @Resource
    FormFieldDao formFieldDao;
    @Autowired(required = false)
    FreemarkerEngine freemarkerEngine;
    @Resource
    FormTemplateManager formTemplateManager;
    @Resource
    FormDefDao formDefDao;
    @Resource
    BoDefService boDefService;
    @Resource
    BusSetDao busSetDao;
    @Resource
    FormRightDao formRightDao;

    @Autowired
    private FormHistoryManager formHistoryManager;

    @Override
    public void create(IForm form) {
        super.create(form);
        // 保持表单的操作记录
        FormHistory bpmFormDefHi = new FormHistory(form);
        formHistoryManager.create(bpmFormDefHi);
    }

    @Override
    public void update(IForm form) {
        super.update(form);
        // 保持表单的操作记录
        FormHistory bpmFormDefHi = new FormHistory(form);
        formHistoryManager.create(bpmFormDefHi);
    }

    @Override
    public List<IForm> getByFormKey(String formKey) {
        return formDao.getByFormKey(formKey);
    }

    @Override
    public IForm getMainByFormKey(String formKey) {
        return formDao.getMainByFormKey(formKey);
    }


    @Override
    public String getHtml(String defId, String tableNames, String templateAliasList) throws Exception {
        String[] tableNameArray = tableNames.split(",");
        String[] templateAliasArray = templateAliasList.split(",");

        FormDef bpmFormdef = formDefDao.selectById(defId);
        JSONArray fieldList = bpmFormdef.getFieldList();

        String html = "";

        for (int i = 0; i < tableNameArray.length; i++) {
            String tableName = tableNameArray[i];

            JSONObject tableField = null; //获取表对象
            for (int j = 0; j < fieldList.size(); j++) {
                JSONObject table = fieldList.getJSONObject(j);
                if (tableName.equals(table.getString("name"))) {
                    tableField = table;
                    break;
                }
            }
            //当前模板
            FormTemplate template = formTemplateManager.getByTemplateAlias(templateAliasArray[i]);
            String macroTemplate = formTemplateManager.getByTemplateAlias(template.getMacrotemplateAlias()).getHtml();
            if (tableField == null || template == null) {
                continue;
            }

            FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("table", tableField);
            map.put("isSub", tableField.getString("type").equals("sub"));
            map.put("formDesc", tableField.getString("description"));
            map.put("fieldList", tableField.getJSONArray("children"));
            map.put("util", freeMakerUtil);

            html += freemarkerEngine.parseByStringTemplate(macroTemplate + template.getHtml(), map);
        }

        return html;
    }


    /**
     * 根据表单定义id创建新的表单版本。 表单定义ID
     *
     * @param formId 自定义表单Id
     * @throws Exception
     */
    @Override
    public void newVersion(String formId) throws Exception {
        IForm Form = this.get(formId);
        createNewVersionForm(Form);
    }


    // 拷贝表单权限
    private void createNewVersionForm(IForm form) {
        Integer rtn = formDao.getMaxVersionByFormKey(form.getFormKey());
        String newFormId = UniqueIdUtil.getSuid();
        // 创建新的版本
        IForm newBpmForm = ObjectUtils.clone(form);
        newBpmForm.setId(newFormId);
        newBpmForm.setMain(true);
        newBpmForm.setStatus(FormStatus.Status.DRAFT);
        newBpmForm.setFormVersion(rtn + 1);

        this.create(newBpmForm);
        publish(newFormId);
        setDefaultVersion(newFormId, newBpmForm.getFormKey());
    }


    /**
     * 设为默认版本。
     *
     * @param formId  自定义表单Id
     * @param formKey 在表单版本使用
     */
    @Override
    public void setDefaultVersion(String formId, String formKey) {
//        formDao.setDefaultVersion(formKey, formId);
    }

    /**
     * 发布
     *
     * @param formId 自定义表单Id
     */
    @Override
    public void publish(String formId) {
        // 设为已发布
        Form formDef = formDao.selectById(formId);
        formDef.setStatus(FormStatus.Status.DEPLOY);
        formDao.updateById(formDef);
    }


    @Override
    public List<IForm> getByDefId(String defId) {
        return formDao.getByDefId(defId);
    }


    /**
     * 导出,是否 导出表单
     */
    /*@Override
    public Map<String, String> exportForms(List<String> idList, boolean containBo) {
        BoDefXml bodefXml = new BoDefXml();
        BpmFormImportXml formImport = new BpmFormImportXml();
        Map<String, String> map = new HashMap<String, String>();
        //取出表单
        for (String formId : idList) {
            FormXml formXml = new FormXml();

            IForm form = this.get(formId);
            FormDef formDef = formDefDao.selectById(form.getDefId());
            List<String> boCodes = formDefDao.getBOCodeByFormId(form.getDefId());

            //表单权限
            FormRight formRightReadOnly = formRightDao.getByFormKey(form.getFormKey(), true);
            FormRight formRightEdit = formRightDao.getByFormKey(form.getFormKey(), false);
            if (formRightReadOnly != null) {
                formXml.getFormRights().add(formRightReadOnly);
            }
            if (formRightEdit != null) {
                formXml.getFormRights().add(formRightEdit);
            }

            //表单业务数据保存
            FormBusSet formSet = busSetDao.getByFormKey(form.getFormKey());
            formXml.setFormBusSet(formSet);

            //表单 和表单定义
            formXml.setBpmForm(form);
            formXml.setBpmFormDef(formDef);
            formXml.setBoCodes(boCodes);

            if (containBo) {
                List<String> boIds = formDefDao.getBODefIdByFormId(form.getDefId());
                for (String boId : boIds) {
                    BaseBoDef bodef = boDefService.getByDefId(boId);
                    bodefXml.addBodef(bodef);
                }
            }

            formImport.addFormXml(formXml);
        }

        try {
            map.put("form.xml", JAXBUtil.marshall(formImport, BpmFormImportXml.class));
            if (containBo) {
                map.put("bo.xml", JAXBUtil.marshall(bodefXml, BoDefXml.class));
            }
        } catch (JAXBException e) {
            e.printStackTrace();
            throw new RuntimeException("导出表单失败" + e.getMessage(), e);
        }
        return map;
    }*/
    @Override
    public void importByFormXml(String xml) throws Exception {
        BpmFormImportXml formImportXml = (BpmFormImportXml) JAXBUtil.unmarshall(xml, BpmFormImportXml.class);
        List<FormXml> formXmlList = formImportXml.getFormXmlList();
        for (FormXml formXml : formXmlList) {
            FormDef formDef = formXml.getBpmFormDef();
            List<String> boCodes = formXml.getBoCodes();
            IForm form = formXml.getBpmForm();

            /**更新bpmFormDef*/
            importFormDef(formDef, boCodes);

            /**
             * 处理表单列表
             * 存在则发布新版本。否则创建。设置默认版本并发布。
             */
            {
                IForm oldForm = getMainByFormKey(form.getFormKey());

                form.setDefId(formDef.getId());
                form.setStatus(FormStatus.Status.DEPLOY);
                if (oldForm != null) {
                    form.setId(oldForm.getId());
                    createNewVersionForm(form);
                    ThreadMsgUtil.addMsg("表单”" + form.getName() + "”[" + form.getFormKey() + "] 已经存在，更新并发布新版本成功！");
                } else {
                    form.setFormVersion(1);
                    form.setMain(true);
                    create(form);
                    ThreadMsgUtil.addMsg("表单“" + form.getName() + "“[" + form.getFormKey() + "] 保存并发布成功！");
                }
            }

            /**
             * 处理表单权限
             */
            {
                //删除已存在的权限
                formRightDao.removeByFormKey(form.getFormKey());
                List<FormRight> formRights = formXml.getFormRights();
                for (FormRight formRight : formRights) {
                    formRightDao.insert(formRight);

                    String permisionType = formRight.getPermissionType() == 1 ? "详细页面" : "编辑页面";
                    ThreadMsgUtil.addMsg("表单”" + form.getName() + "”" + permisionType + "权限更新成功！");
                }
            }
            /**
             * 处理表单业务数据保存
             */
            {
                busSetDao.removeByFormKey(form.getFormKey());
                FormBusSet formBusSet = formXml.getFormBusSet();
                if (formBusSet != null) {
                    busSetDao.insert(formBusSet);
                }
                ThreadMsgUtil.addMsg("表单”" + form.getName() + "”业务数据保存设置更新成功！");
            }
        }
    }

    /**
     * 导入表单定义
     *
     * @param formDef
     * @param boCodes
     */
    private void importFormDef(FormDef formDef, List<String> boCodes) {

        FormDef oldFormDef = formDefDao.getByKey(formDef.getDefKey());

        //重新构建bo关系json
        Map<String, BaseBoDef> boDefMap = new HashMap<String, BaseBoDef>();
        JSONObject expand = JSONObject.parseObject(formDef.getExpand());
        JSONArray boDefList = JSONArray.newJSONArray();
        for (String boCode : boCodes) {
            BaseBoDef boDef = boDefService.getByAlias(boCode);
            boDefMap.put(boCode, boDef);

            JSONObject boDefJson = JSONObject.newJSONObject();
            boDefJson.put("id", boDef.getId());
            boDefJson.put("desc", boDef.getDescription());
            boDefList.add(boDefJson);

        }
        expand.put("boDefList", boDefList);
        formDef.setExpand(expand.toJSONString());


        if (oldFormDef != null) {
            formDef.setId(oldFormDef.getId());
            //删除已存在的formField,
            formFieldDao.delByMainId(formDef.getId());
            //创建formField,权限有用到，formDef ID确定的情况下保存
            handelFormFields(formDef, boDefMap);

            formDefDao.updateById(formDef);
            ThreadMsgUtil.addMsg("表单元数据定义 ”" + formDef.getName() + "“[" + formDef.getDefKey() + "] 已经存在，更新成功！");
        } else {
            formDef.setId(UniqueIdUtil.getSuid());
            handelFormFields(formDef, boDefMap);

            formDefDao.insert(formDef);
            ThreadMsgUtil.addMsg("表单元数据定义 “" + formDef.getName() + "”[" + formDef.getDefKey() + "] 添加成功！");
        }

        formDefDao.deleteFormBo(formDef.getId());
        for (Object obj : boDefList) {
            JSONObject boDefJson = (JSONObject) obj;
            //创建表单和BO的关联关系。
            formDefDao.createFormBo(UniqueIdUtil.getSuid(), boDefJson.getString("id"), formDef.getId());
        }


    }


    // 重新设置 field 的boDefId entId
    private void handelFormFields(FormDef formDef, Map<String, BaseBoDef> boDefMap) {
        JSONObject expand = JSONObject.parseObject(formDef.getExpand());
        JSONArray tables = expand.getJSONArray("fields");
        for (Object t : tables) {
            JSONObject table = (JSONObject) t;
            String tableName = table.getString("name");
            String boCode = table.getString("path").split("\\.")[0];

            BaseBoDef boDef = boDefMap.get(boCode);
            BaseBoEnt ent = boDefService.getEntByName(tableName);
            if (boDef == null || ent == null) {
                throw new RuntimeException("表定义字段数据出现异常！");
            }

            table.put("entId", ent.getId());
            table.put("boDefId", boDef.getId());

            JSONArray fields = table.getJSONArray("children");
            for (int i = 0; i < fields.size(); i++) {
                JSONObject field = fields.getJSONObject(i);
                field.put("entId", ent.getId());
                field.put("boDefId", boDef.getId());

                //数据库持久化formField
                FormField formField = (FormField) JSON.parseObject(field.toString(), FormField.class);
                formField.setId(UniqueIdUtil.getSuid());
                formField.setFormId(formDef.getId());
                formFieldDao.insert(formField);
            }
        }

        formDef.setExpand(expand.toJSONString());
    }


    @Override
    public String genByField(String defId, String attrId, String formType) {
        FormDef def = formDefDao.selectById(defId);
        JSONObject expand = JSONObject.parseObject(def.getExpand());
        JSONArray tables = expand.getJSONArray("fields");
        JSONObject field = JSONObject.newJSONObject();
        boolean isSub = false;

        for (Object t : tables) {
            JSONObject table = (JSONObject) t;
            JSONArray fields = table.getJSONArray("children");
            for (int i = 0; i < fields.size(); i++) {
                JSONObject f = fields.getJSONObject(i);
                if (f.getString("boAttrId").equals(attrId)) {
                    field = f;
                    isSub = !table.getString("type").equals("main");
                }
            }
        }

        String macroTemplate = formTemplateManager.getByTemplateAlias("mobile".equals(formType) ? "mobileFieldMacro" : "fieldControl").getHtml();

        FreeMakerUtil freeMakerUtil = new FreeMakerUtil();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("isSub", isSub);
        map.put("field", field);
        map.put("util", freeMakerUtil);
        String template = "<@input field=field isSub=isSub/>" + macroTemplate;
        String html = "";
        try {
            html = freemarkerEngine.parseByStringTemplate(template, map);
        } catch (Exception e) {
            html = "出现异常！";
        }
        return html;
    }

    /**
     * 删除表单。
     * <pre>
     * 1.删除表单定义。
     * 2.删除业务表单配置。
     * 3.删除表单权限。
     * </pre>
     */
    @Override
    public void remove(String defId) {
        IForm form = formDao.selectById(defId);
        String formKey = form.getFormKey();

        formRightDao.removeByFormKey(formKey);
        busSetDao.removeByFormKey(formKey);

        super.remove(defId);
    }


}
