package cn.sexycode.springo.form.manager.impl;

import cn.sexycode.springo.core.data.db.manager.impl.BaseManagerImpl;
import cn.sexycode.springo.form.dao.BusSetDao;
import cn.sexycode.springo.form.manager.FormBusSetManager;
import cn.sexycode.springo.form.model.FormBusSet;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * <pre>
 * 描述：form_bus_set 处理实现类
 * </pre>
 */
@Service("formBusSetManager")
public class FormBusSetManagerImpl extends BaseManagerImpl<FormBusSet> implements FormBusSetManager {
    @Resource
    BusSetDao busSetDao;


    @Override
    public FormBusSet getByFormKey(String formKey) {
        return busSetDao.getByFormKey(formKey);
    }

    @Override
    public boolean isExist(FormBusSet formSet) {
        return busSetDao.isExist(formSet);
    }
}
