package cn.sexycode.springo.form.manager.impl;

import cn.sexycode.springo.bo.constant.BodefConstants;
import cn.sexycode.springo.bo.def.BoDefService;
import cn.sexycode.springo.bo.instance.BoDataHandler;
import cn.sexycode.springo.bo.instance.BoInstanceFactory;
import cn.sexycode.springo.bo.instance.BoUtil;
import cn.sexycode.springo.bo.instance.DataTransform;
import cn.sexycode.springo.bo.model.BaseBoDef;
import cn.sexycode.springo.bo.model.BaseBoEnt;
import cn.sexycode.springo.bo.model.BoData;
import cn.sexycode.springo.bo.model.BoResult;
import cn.sexycode.springo.core.base.core.engine.script.GroovyScriptEngine;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.core.base.core.util.BeanUtils;
import cn.sexycode.springo.core.base.core.util.ThreadMsgUtil;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.form.dto.FormBusDataDTO;
import cn.sexycode.springo.form.manager.*;
import cn.sexycode.springo.form.model.FormBusSet;
import cn.sexycode.springo.form.model.FormDef;
import cn.sexycode.springo.form.model.IForm;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 描述：form_bus_set 处理实现类
 * </pre>
 */
@Service("formBusManager")
public class FormBusManagerImpl implements FormBusManager {
    private final Logger log = LoggerFactory.getLogger(getClass());

    private BoInstanceFactory boInstanceFactory;
    private BoDefService boDefService;
    private DataTransform dataTransform;
    private FormBusSetManager formBusSetManager;
    private FormManager formManager;
    private FormDefManager formDefManager;
    private GroovyScriptEngine groovyScriptEngine;
    private FormRightManager formRightManager;
    @Override
    public BoData getBoData(String boKey, Object id, JSONObject permission) {
        BoDataHandler boDataHandler = boInstanceFactory.getBySaveType(BodefConstants.SAVE_MODE_DB);

        try {
            if (BeanUtils.isNotEmpty(id)) {
                return boDataHandler.getById(id, boKey, permission);
            }
        } catch (Exception e) {
            if (e.getCause() instanceof EmptyResultDataAccessException) {
                //找不到数据在现系统中相当于没错
            } else {
                log.error(e.getMessage(), e);
            }
        }
        return boDataHandler.getByBoDefCode(boKey);

    }

    @Override
    public void saveData(String formKey, String json) {
        BoDataHandler boDataHandler = boInstanceFactory.getBySaveType(BodefConstants.SAVE_MODE_DB);
        String boCode = getBoCodeByForm(formKey);

        BaseBoDef boDef = boDefService.getByName(boCode);
        BaseBoEnt boEnt = boDef.getBoEnt();

        BoData curData = dataTransform.parse(json);
        curData.setBoDef(boDef);
        curData.setBoEnt(boEnt);

        FormBusSet busSet = formBusSetManager.getByFormKey(formKey);
        Map<String, Object> param = new HashMap<String, Object>();
        param.put("boData", curData);

        //前置脚本
        if (busSet != null && StringUtil.isNotEmpty(busSet.getPreScript())) {
            groovyScriptEngine.execute(busSet.getPreScript(), param);
        }

        JSONObject permissionConf = formRightManager.getByFormKey(formKey, false);
        JSONObject permission = formRightManager.calcFormPermission(permissionConf);

        // 保存 TODO为了兼容旧版本 表单保存时先不要处理权限
        List<BoResult> listResult = boDataHandler.save("", "", curData, null);
        //后置脚本
        if (busSet != null && StringUtil.isNotEmpty(busSet.getAfterScript())) {
            groovyScriptEngine.execute(busSet.getAfterScript(), param);
        }


        if (BeanUtils.isNotEmpty(listResult)) {
            if ("add".equals(listResult.get(0).getAction())) {
                ThreadMsgUtil.addMsg("添加成功！");
            } else {
                ThreadMsgUtil.addMsg("编辑成功！");
            }
        }
    }

    @Override
    public void removeByIds(String[] aryIds, String formKey) {
        BoDataHandler boDataHandler = boInstanceFactory.getBySaveType(BodefConstants.SAVE_MODE_DB);
        String boCode = getBoCodeByForm(formKey);

        boDataHandler.removeBoData(boCode, aryIds);
    }


    private String getBoCodeByForm(String formKey) {
        IForm form = formManager.getMainByFormKey(formKey);
        FormDef formDef = formDefManager.get(form.getDefId());
        List<String> boCode = formDefManager.getBoCodeByFormId(formDef.getId());

        if (boCode.size() != 1) {
            throw new RuntimeException(formKey + "表单所对应的BO数据不支持改操作！");
        }
        return boCode.get(0);
    }

    @Override
    public JSONArray getList(String formKey, Map<String, Object> param) {
        String boCode = getBoCodeByForm(formKey);
        BoDataHandler boDataHandler = boInstanceFactory.getBySaveType(BodefConstants.SAVE_MODE_DB);

        List<Map<String, Object>> list = boDataHandler.getList(boCode, param);
        JSONArray jsonArray = (JSONArray) JSON.toJSON(list);
        return jsonArray;
    }

    @Override
    public FormBusDataDTO getData(boolean readonly, String formKey, Object id) {

        FormBusSet formBusSet = formBusSetManager.getByFormKey(formKey);

        IForm form = formManager.getMainByFormKey(formKey);
        FormDef formDef = formDefManager.get(form.getDefId());
        List<String> boCodeList = formDefManager.getBoCodeByFormId(formDef.getId());
        String boCode = boCodeList.get(0);

        JSONObject permissionConf = formRightManager.getByFormKey(formKey, readonly);
        JSONObject permission = formRightManager.calcFormPermission(permissionConf);

        BoData boData = getBoData(boCode, id, null);

        //处理后置事件
        handleBusShowScript(boData, permission, formBusSet, formKey, readonly, id);

        String formHtml = form.getFormHtml();

        FormBusDataDTO formBusDataDTO = new FormBusDataDTO();
        formBusDataDTO.setBoCode(boCode);
        formBusDataDTO.setData(BoUtil.toJSONObject(boData, true));
        formBusDataDTO.setFormBusSet(formBusSet);
        formBusDataDTO.setPermission(permission);
        formBusDataDTO.setFormHtml(formHtml);

        return formBusDataDTO;
    }


    /**
     * 处理展示前置脚本
     *
     * @param boData
     * @param permission
     * @param formBusSet
     * @param id
     */
    private void handleBusShowScript(BoData boData, JSONObject permission, FormBusSet formBusSet, String formKey, boolean readonly, Object id) {
        if (formBusSet == null || StringUtil.isEmpty(formBusSet.getShowScript())) {
            return;
        }

        Map<String, Object> map = new HashMap<String, Object>();
        map.put("boData", boData);
        map.put("formKey", formKey);
        //如果只读，则不再加工权限
        if (readonly) {
            map.put("permission", JSONObject.parseObject(permission.toJSONString()));
        } else {
            map.put("permission", permission);
        }

        map.put("readonly", readonly);
        if (id instanceof Map) {
            map.put("param", id);
        }

        groovyScriptEngine.execute(formBusSet.getShowScript(), map);

    }

    @Autowired
    public void setBoInstanceFactory(BoInstanceFactory boInstanceFactory) {
        this.boInstanceFactory = boInstanceFactory;
    }

    @Autowired
    public void setBoDefService(BoDefService boDefService) {
        this.boDefService = boDefService;
    }

    @Autowired
    public void setDataTransform(DataTransform dataTransform) {
        this.dataTransform = dataTransform;
    }

    @Autowired
    public void setFormBusSetManager(FormBusSetManager formBusSetManager) {
        this.formBusSetManager = formBusSetManager;
    }

    @Autowired
    public void setFormManager(FormManager formManager) {
        this.formManager = formManager;
    }

    @Autowired
    public void setFormDefManager(FormDefManager formDefManager) {
        this.formDefManager = formDefManager;
    }

    @Autowired
    public void setGroovyScriptEngine(GroovyScriptEngine groovyScriptEngine) {
        this.groovyScriptEngine = groovyScriptEngine;
    }

    @Autowired
    public void setFormRightManager(FormRightManager formRightManager) {
        this.formRightManager = formRightManager;
    }

}
