package cn.sexycode.springo.form.manager;


import cn.sexycode.springo.core.data.db.manager.api.Manager;
import cn.sexycode.springo.form.model.FormTemplate;

import java.util.List;

public interface FormTemplateManager extends Manager<FormTemplate> {

    /**
     * 根据模版别名取得模版。
     *
     * @param alias
     * @return
     */
    FormTemplate getByTemplateAlias(String alias);

    /**
     * 获取所有的系统原始模板
     *
     * @throws Exception
     */
    void initAllTemplate() throws Exception;

    /**
     * 当模版数据为空时，将form目录下的模版添加到数据库中。
     */
    void init() throws Exception;


    /**
     * 检查模板别名是否唯一
     *
     * @param alias
     * @return
     */
    boolean isExistAlias(String alias);


    /**
     * 将用户自定义模板备份
     *
     * @param id
     */
    void backUpTemplate(String id);

    /**
     * 根据模版类型取得模版列表。
     *
     * @param type
     * @return
     */
    List<FormTemplate> getTemplateType(String type);

    /**
     * 获取主表模版
     *
     * @return
     */
    List<FormTemplate> getAllMainTableTemplate(boolean isPC);

    /**
     * 获取子表模版。
     *
     * @return
     */
    List<FormTemplate> getAllSubTableTemplate(boolean isPC);

    /**
     * 获取宏模版。
     *
     * @return
     */
    List<FormTemplate> getAllMacroTemplate();

    /**
     * 获取表管理模版。
     *
     * @return
     */
    List<FormTemplate> getAllTableManageTemplate();

    /**
     * 获取列表模版。
     *
     * @return
     */
    List<FormTemplate> getListTemplate();

    /**
     * 获取明细模版。
     *
     * @return
     */
    List<FormTemplate> getDetailTemplate();

    /**
     * 获取数据模版。
     *
     * @return
     */
    List<FormTemplate> getDataTemplate();

    /**
     * 获取查询数据模版。
     *
     * @return
     */
    List<FormTemplate> getQueryDataTemplate();
}
