package cn.sexycode.springo.form.manager;

import cn.sexycode.springo.core.data.db.manager.api.Manager;
import cn.sexycode.springo.form.model.IForm;

import java.util.List;

/**
 * @author qinzaizhen
 */
public interface FormManager extends Manager<IForm> {
    /**
     * 通过模板生成表单Html
     *
     * @param formId               表单主键
     * @param mainFieldTemplate    主模板
     * @param subFieldListTemplate 复合字段模板
     * @return
     */

    String getHtml(String formId, String mainFieldTemplate, String subFieldListTemplate) throws Exception;

    /**
     * 根据formKey 取得表单定义。
     *
     * @param formKey
     * @return IForm
     */
    IForm getMainByFormKey(String formKey);

    /**
     * 根据formKey 取得表单定义。
     *
     * @param formKey
     * @return {@code List<IForm> }
     */
    List<IForm> getByFormKey(String formKey);


    void newVersion(String formId) throws Exception;

    void setDefaultVersion(String formId, String formKey);

    void publish(String formId);

    List<IForm> getByDefId(String defId);


    void importByFormXml(String formXml) throws Exception;

    /*Map<String, String> exportForms(List<String> idList, boolean containBo);*/

    //生成字段的html
    String genByField(String defId, String attrId, String formType);
}