package cn.sexycode.springo.form.manager;


import cn.sexycode.springo.core.data.db.manager.api.Manager;
import cn.sexycode.springo.form.model.FormDef;
import cn.sexycode.springo.form.rest.vo.FormDefVO;

import java.util.List;

/**
 * <pre>
 * 描述：bpm_form_def 处理接口
 * </pre>
 * @author qinzaizhen
 */
public interface FormDefManager extends Manager<FormDef> {

    /**
     * 根据bo定义ID获取对应的表单元数据定义。
     *
     * @param BODefId
     * @return
     */
    List<FormDef> getByBODefId(String BODefId);

    void save(FormDefVO formDefVO);

    /**
     * 根据表单key获取表单元数据定义。
     *
     * @param formKey
     * @return
     */
    FormDef getByKey(String formKey);

    /**
     * 更新表单意见配置。
     *
     * @param id
     * @param config
     */
    void updateOpinionConf(String id, String config);

    /**
     * 根据表单获取表单元数据key。
     *
     * @param formKey
     * @return
     */
    String getMetaKeyByFormKey(String formKey);

    List<String> getBoCodeByFormId(String formDefId);

    void update(FormDefVO formDefVO);
}
