package cn.sexycode.springo.form.manager;

import cn.sexycode.springo.bo.model.BoData;
import cn.sexycode.springo.core.base.core.json.JSONArray;
import cn.sexycode.springo.core.base.core.json.JSONObject;
import cn.sexycode.springo.form.dto.FormBusDataDTO;

import java.util.Map;


/**
 * <pre>
 * 描述：form_bus_set 处理接口
 * </pre>
 */
public interface FormBusManager {
    /**
     * 通过 boKey，id获取bo数据
     *
     * @param boKey
     * @param id
     * @param permission :权限
     * @return
     */
    BoData getBoData(String boKey, Object id, JSONObject permission);

    /**
     * 通过formKey json 保存bo数据
     *
     * @param formKey
     * @param json
     */
    void saveData(String formKey, String json);

    /**
     * 通过formKey 删除业务数据
     *
     * @param aryIds
     * @param formKey
     */
    void removeByIds(String[] aryIds, String formKey);

    /**
     * 通过 formKey 获取业务数据
     *
     * @param formKey
     * @param param
     * @return
     */
    JSONArray getList(String formKey, Map<String, Object> param);

    FormBusDataDTO getData(boolean readonly, String formKey, Object id);
}
