package cn.sexycode.springo.form.dao;


import cn.sexycode.springo.core.data.db.api.model.Dao;
import cn.sexycode.springo.form.model.FormRight;

import java.util.List;

/**
 * <pre>
 * 描述：BPM_FORM_RIGHT DAO接口
 * </pre>
 */
public interface FormRightDao extends Dao<FormRight> {

    /**
     * 根据流程定义Id获取权限配置数据。
     *
     * @param flowKey       流程定义KEY
     * @param parentFlowKey 父级流程定义KEY
     * @return
     */
    FormRight getByFlowKey(String flowKey, String parentFlowKey, int permissionType);


    /**
     * 根据流程定义ID节点ID 和父流程定义ID获取权限配置数据。
     *
     * @param flowKey
     * @param nodeId
     * @param parentFlowKey
     * @return
     */
    FormRight getByFlowNodeId(String flowKey, String nodeId, String parentFlowKey);

    /**
     * 根据表单的Key获取表单配置的基础权限。
     *
     * @param formKey    flowKey 为null 的数据
     * @param isReadOnly 是否只读权限
     * @return
     */
    FormRight getByFormKey(String formKey, boolean isReadOnly);

    /**
     * 根据流程key和流程节点删除权限。
     *
     * @param flowKey
     * @param nodeId
     * @param parentFlowKey
     */
    void removeByFlowNode(String flowKey, String nodeId, String parentFlowKey);

    /**
     * 根据流程key进行删除。
     *
     * @param flowKey
     * @param parentFlowKey
     * @param permissionType
     */
    void removeByFlowKey(String flowKey, String parentFlowKey, int permissionType);


    /**
     * 根据formKey删除表单权限。
     *
     * @param formKey
     */
    void removeByFormKey(String formKey);

    /**
     * 根据flowKey删除流程所有权限。
     *
     * @param formKey
     */
    void removeAllFlowRights(String formKey, String parentFlowKey);

    /**
     * 通过流程key获取流程所有权限配置
     *
     * @param flowKey
     * @param parentFlowKey
     * @return
     */
    List<FormRight> getAllFlowRights(String flowKey, String parentFlowKey);

    /**
     * 删除业务表单配置的权限
     *
     * @param formKey
     * @param type
     */
    void removeBusFormPermision(String formKey, int type);


}
