package cn.sexycode.springo.form.dao;


import cn.sexycode.springo.core.data.db.api.model.Dao;
import cn.sexycode.springo.form.model.FormField;

import java.util.List;

public interface FormFieldDao extends Dao<FormField> {
    /**
     * 根据外键获取子表明细列表
     *
     * @param formId
     * @return
     */
    List<FormField> getByFormId(String formId);

    /**
     * 通过表单ID获取字段列表(不包含属于分组的字段)
     *
     * @param formId
     * @return
     */
    List<FormField> getOnlyByFormId(String formId);


    /**
     * 通过分组ID获取字段列表
     *
     * @param groupId
     * @return
     */
    List<FormField> getByGroupId(String groupId);

    /**
     * 根据外键删除子表记录
     *
     * @param formId
     */
    void delByMainId(String formId);

    /**
     * 根据formId 获取列表。
     *
     * @param formId
     * @return
     */
    List<FormField> getExtByFormId(String formId);


    void removeByAttrId(String attrId);

}
