package cn.sexycode.springo.form.dao;


import cn.sexycode.springo.core.data.db.api.model.Dao;
import cn.sexycode.springo.form.model.FormDef;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * <pre>
 * 描述：bpm_form_def DAO接口
 * </pre>
 */
public interface FormDefDao extends Dao<FormDef> {

    /**
     * 通过表单ID删除 表单BO关联表中的记录
     *
     * @param formId
     */
    void deleteFormBo(String formId);

    /**
     * 创建表单BO关联记录
     *
     * @param id
     * @param boDefId
     * @param formId
     */
    void createFormBo(@Param("id") String id, @Param("boDefId") String boDefId, @Param("formId") String formId);


    /**
     * 通过表单ID获取关联的BODefID
     *
     * @param formId
     * @return
     */
    List<String> getBODefIdByFormId(String formId);

    /**
     * 根据formId获取bocode 列表。
     *
     * @param formId
     * @return
     */
    List<String> getBOCodeByFormId(String formId);

    /**
     * 根据BODefId 获取相关的表单定义。
     *
     * @param BODefId
     * @return
     */
    List<FormDef> getByBODefId(String BODefId);

    /**
     * 根据formKey 获取表单定义。
     *
     * @param formKey
     * @return
     */
    FormDef getByKey(String formKey);

    /**
     * 更新表单元素书的意见定义。
     *
     * @param id
     * @param opinionJson
     */
    void updateOpinionConf(String id, String opinionJson);

    /**
     * 根据表单ID获取bo实体信息数据。
     * 获取实体名称和实例关系。
     *
     * @param formId
     * @return
     */
    List<Map<String, String>> getEntInfoByFormId(String formId);

    /**
     * 根据实体名获取表单列表。
     *
     * @param name
     * @return
     */
    List<FormDef> getByEntName(String name);

    /**
     * 根据表单获取表单元数据key。
     *
     * @param formKey
     * @return
     */
    String getMetaKeyByFormKey(String formKey);

    /**
     * 根据entId 获取关联的表单定义。
     *
     * @param entId
     * @return
     */
    List<FormDef> getByEntId(String entId);
}
