package cn.sexycode.springo.form.dao;


import cn.sexycode.springo.core.data.db.api.model.Dao;
import cn.sexycode.springo.core.data.db.api.query.QueryFilter;
import cn.sexycode.springo.form.model.IForm;
import cn.sexycode.springo.form.model.impl.Form;

import java.util.List;

/**
 * @author qinzaizhen
 */
public interface FormDao extends Dao<Form> {

    /**
     * 根据表单key获取表单对象数据。
     *
     * @param formKey
     * @return IForm
     */
    IForm getMainByFormKey(String formKey);

    /**
     * 根据formKey 取得表单定义。
     *
     * @param formKey
     * @return {@code List<IForm> }
     */
    List<IForm> getByFormKey(String formKey);

    /**
     * 通过bocode获取与bo绑定的表单
     *
     * @param codes
     * @return
     */
    List<IForm> getByBoCodes(List<String> codes, String formType, QueryFilter filter);

    Integer getBpmFormCountsByFormKey(String formKey);

    Integer getMaxVersionByFormKey(String formKey);

    List<IForm> getByDefId(String defId);
}
