package cn.sexycode.springo.form.dao;

import cn.sexycode.springo.core.data.db.api.model.Dao;
import cn.sexycode.springo.form.model.FormBusSet;

/**
 * <pre>
 * 描述：表单业务数据保存设置 DAO
 * </pre>
 */
public interface BusSetDao extends Dao<FormBusSet> {

    FormBusSet getByFormKey(String formKey);

    /**
     * 判断业务数据保存设置是否存在。
     *
     * @param formSet
     * @return
     */
    boolean isExist(FormBusSet formSet);

    /**
     * 根据表单键删除业务数据设置。
     *
     * @param formKey
     */
    void removeByFormKey(String formKey);
}
