package cn.sexycode.springo.form;

import cn.sexycode.springo.core.base.api.IEnum;
import cn.sexycode.springo.core.base.core.BaseConfiguration;
import cn.sexycode.springo.core.base.core.spring.EnumTypeWrapper;
import cn.sexycode.springo.core.base.core.spring.EnumTypeWrapperComposite;
import cn.sexycode.springo.core.data.db.mybatis.handler.EnumTypeHandler;
import cn.sexycode.springo.core.data.db.mybatis.handler.EnumTypeRegister;
import cn.sexycode.springo.core.web.EnumDeserializer;
import cn.sexycode.springo.form.model.FormFiledType;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author qinzaizhen
 */
@Configuration
@Import(BaseConfiguration.class)
@ComponentScan(basePackages = "cn.sexycode.springo.form")
@MapperScan(basePackages = "cn.sexycode.springo.form.**.dao")
public class FormConfiguration {

    @Bean
    @ConditionalOnMissingBean
    public EnumTypeWrapper<FormFiledType> defaultEnumTypeWrapper() {
        return new EnumTypeWrapper<FormFiledType>() {

            {
                enums = new ConcurrentHashMap<>();
                putEnum(FormFiledType.class, FormFiledType.Type.class);
            }

            private Map<Class<? extends IEnum>, List> enums;

            @Override
            public List<FormFiledType> getEnumList(Class<FormFiledType> enumClass) {
                return enums.getOrDefault(enumClass, new ArrayList<>());
            }

            @Override
            public void putEnum(Class<FormFiledType> enumClass, Class<? extends Enum> enumType) {
                List list = enums.getOrDefault(enumClass, new ArrayList<>());
                list.add(enumType);
                enums.put(enumClass, list);
            }
        };
    }

    @Bean
    public EnumTypeWrapperComposite enumTypeWrapperComposite() {
        return new EnumTypeWrapperComposite() {
        };
    }

    @Bean
    public EnumTypeRegister formTypeEnumTypeRegister() {
        return new EnumTypeRegister() {
            @Override
            public Class getResultTypeHandler() {
                return EnumTypeHandler.class;
            }

            @Override
            public Class getJavaType() {
                return FormFiledType.class;
            }
        };
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer customizer() {
        return new Jackson2ObjectMapperBuilderCustomizer() {

            @Override
            public void customize(Jackson2ObjectMapperBuilder jacksonObjectMapperBuilder) {
                jacksonObjectMapperBuilder.deserializerByType(FormFiledType.class, new EnumDeserializer<>(FormFiledType.class));
            }
        };
    }
}
