/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.springo.data.boot.autoconfigure;

import cn.sexycode.springo.core.base.api.IEnum;
import cn.sexycode.springo.core.base.core.util.string.StringUtil;
import cn.sexycode.springo.core.data.db.DataConfiguration;
import cn.sexycode.springo.core.data.db.mybatis.PageInterceptor;
import cn.sexycode.springo.core.data.db.mybatis.dialect.MySQLDialect;
import cn.sexycode.springo.core.data.db.mybatis.handler.BooleanTypeHandler;
import cn.sexycode.springo.core.data.db.mybatis.handler.EnumTypeHandler;
import cn.sexycode.springo.core.data.db.mybatis.handler.EnumTypeRegister;
import cn.sexycode.springo.core.data.db.mybatis.support.SqlInjector;
import cn.sexycode.springo.data.boot.autoconfigure.DataProperties;
import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.util.ReflectionUtils;

@EnableAutoConfiguration
@Configuration
@Import(value={DataConfiguration.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class})
@EnableConfigurationProperties(value={DataProperties.class})
@AutoConfigureBefore(value={MybatisPlusAutoConfiguration.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@Aspect
public class DataAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAutoConfiguration.class);
    private final DataProperties dataProperties;

    public DataAutoConfiguration(ApplicationContext applicationContext, DataProperties dataProperties) {
        this.dataProperties = dataProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public SqlInjector sqlInjector() {
        return new SqlInjector();
    }

    @Pointcut(value="execution(* com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration.sqlSessionFactory(..))")
    public void mybatisPlusConfigPointcut() {
    }

    @Before(value="mybatisPlusConfigPointcut()")
    public void injectMapperLocation(JoinPoint joinPoint) {
        Object target = joinPoint.getTarget();
        if (target instanceof MybatisPlusAutoConfiguration) {
            if (this.dataProperties.isInjectNestMapper()) {
                Field field = ReflectionUtils.findField(MybatisPlusAutoConfiguration.class, (String)"properties");
                if (field != null) {
                    ReflectionUtils.makeAccessible((Field)field);
                    Object properties = ReflectionUtils.getField((Field)field, (Object)target);
                    if (properties != null) {
                        MybatisPlusProperties mybatisPlusProperties = (MybatisPlusProperties)properties;
                        String[] mapperLocations = mybatisPlusProperties.getMapperLocations();
                        ArrayList<String> mapperLocationList = new ArrayList<String>();
                        mapperLocationList.add("classpath*:framework/mapper/*.mapper.xml");
                        if (mapperLocations != null) {
                            mapperLocationList.addAll(Arrays.asList(mapperLocations));
                        }
                        mybatisPlusProperties.setMapperLocations(mapperLocationList.toArray(new String[0]));
                    } else {
                        LOGGER.warn("\u672a\u8bfb\u53d6\u5230MybatisPlusAutoConfiguration \u5c5e\u6027 properties\u7684\u503c");
                    }
                } else {
                    LOGGER.warn("\u672a\u8bfb\u53d6\u5230MybatisPlusAutoConfiguration \u7684\u5c5e\u6027 properties");
                }
            } else {
                LOGGER.info("\u5ffd\u7565\u6ce8\u5165\u6846\u67b6mapper");
            }
        }
    }

    @Bean
    public ConfigurationCustomizer customizer(List<EnumTypeRegister> enumTypeRegisters) {
        return configuration -> {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            try {
                typeHandlerRegistry.register(Boolean.class.getName(), BooleanTypeHandler.class.getCanonicalName());
                typeHandlerRegistry.register(IEnum.class.getName(), EnumTypeHandler.class.getCanonicalName());
                if (CollectionUtils.isNotEmpty((Collection)enumTypeRegisters)) {
                    enumTypeRegisters.forEach(r -> typeHandlerRegistry.register(r.getJavaType(), r.getResultTypeHandler()));
                }
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("\u6ce8\u518c\u7c7b\u578b\u8f6c\u6362\u5668\u5931\u8d25: ", (Throwable)e);
            }
        };
    }

    @Bean
    public PageInterceptor paginationInterceptor() {
        PageInterceptor pageInterceptor = new PageInterceptor();
        Properties properties = new Properties();
        properties.put("Dialect.mysql", MySQLDialect.class.getName());
        if (StringUtil.isNotZeroEmpty((String)this.dataProperties.getDbType())) {
            properties.put("dbType", this.dataProperties.getDbType());
        } else {
            properties.put("dbType", "mysql");
        }
        pageInterceptor.setProperties(properties);
        return pageInterceptor;
    }

    @Bean
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInterceptor();
    }
}

