/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.myjpa.orm.vendor;

import cn.sexycode.myjpa.MyjpaPersistenceProvider;
import cn.sexycode.myjpa.orm.vendor.MyjpaDialect;
import cn.sexycode.myjpa.session.Session;
import cn.sexycode.myjpa.session.SessionFactory;
import cn.sexycode.sql.dialect.MySQLDialect;
import cn.sexycode.util.core.factory.BeanFactoryUtil;
import cn.sexycode.util.core.str.StringUtils;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;

public class MyjpaVendorAdapter
extends AbstractJpaVendorAdapter
implements InitializingBean {
    private final MyjpaDialect jpaDialect = new MyjpaDialect();
    private SqlSessionFactory sessionFactory;
    private String sqlSessionFactoryBeanName;
    private PersistenceProvider persistenceProvider;

    public MyjpaVendorAdapter() {
        if (StringUtils.isNotEmpty((CharSequence)this.getSqlSessionFactoryBeanName())) {
            this.sessionFactory = (SqlSessionFactory)BeanFactoryUtil.getBeanFactory().getBean(this.getSqlSessionFactoryBeanName());
            this.persistenceProvider = new MyjpaPersistenceProvider(this.sessionFactory);
        } else {
            this.persistenceProvider = this.getSessionFactory() != null ? new MyjpaPersistenceProvider(this.getSessionFactory()) : null;
        }
    }

    public MyjpaVendorAdapter(SqlSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.persistenceProvider = new MyjpaPersistenceProvider(sessionFactory);
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    public String getPersistenceProviderRootPackage() {
        return "cn.sexycode.myjpa";
    }

    public Map<String, Object> getJpaPropertyMap(PersistenceUnitInfo pui) {
        return this.getJpaPropertyMap();
    }

    public Map<String, Object> getJpaPropertyMap() {
        HashMap<String, Object> jpaProperties = new HashMap<String, Object>(5);
        if (this.getDatabasePlatform() != null) {
            jpaProperties.put("myjpa.dialect", this.getDatabasePlatform());
        } else {
            Class<?> databaseDialectClass = this.determineDatabaseDialectClass(this.getDatabase());
            if (databaseDialectClass != null) {
                jpaProperties.put("myjpa.dialect", databaseDialectClass.getName());
            }
        }
        if (this.isShowSql()) {
            jpaProperties.put("hibernate.show_sql", "true");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getSqlSessionFactoryBeanName())) {
            jpaProperties.put("myjpa.mybatis.sessionFactory.name", this.getSqlSessionFactoryBeanName());
        }
        return jpaProperties;
    }

    protected Class<?> determineDatabaseDialectClass(Database database) {
        switch (database) {
            case MYSQL: {
                return MySQLDialect.class;
            }
        }
        return null;
    }

    public MyjpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    public Class<? extends EntityManagerFactory> getEntityManagerFactoryInterface() {
        return SessionFactory.class;
    }

    public Class<? extends EntityManager> getEntityManagerInterface() {
        return Session.class;
    }

    public String getSqlSessionFactoryBeanName() {
        return this.sqlSessionFactoryBeanName;
    }

    public void setSqlSessionFactoryBeanName(String sqlSessionFactoryBeanName) {
        this.sqlSessionFactoryBeanName = sqlSessionFactoryBeanName;
    }

    public SqlSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SqlSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void afterPropertiesSet() {
        if (this.getPersistenceProvider() == null) {
            if (StringUtils.isNotEmpty((CharSequence)this.getSqlSessionFactoryBeanName())) {
                this.sessionFactory = (SqlSessionFactory)BeanFactoryUtil.getBeanFactory().getBean(this.getSqlSessionFactoryBeanName());
                this.persistenceProvider = new MyjpaPersistenceProvider(this.sessionFactory);
            } else {
                this.persistenceProvider = this.getSessionFactory() != null ? new MyjpaPersistenceProvider(this.getSessionFactory()) : new MyjpaPersistenceProvider();
            }
        }
    }
}

