/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.myjpa.orm.vendor;

import cn.sexycode.myjpa.session.Session;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.springframework.jdbc.datasource.ConnectionHandle;
import org.springframework.lang.Nullable;
import org.springframework.orm.jpa.DefaultJpaDialect;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;

public class MyjpaDialect
extends DefaultJpaDialect {
    public Object beginTransaction(EntityManager entityManager, TransactionDefinition definition) throws PersistenceException, SQLException, TransactionException {
        Session session = (Session)entityManager.unwrap(Session.class);
        if (definition.getTimeout() != -1) {
            // empty if block
        }
        boolean isolationLevelNeeded = definition.getIsolationLevel() != -1;
        Integer previousIsolationLevel = null;
        Connection preparedCon = null;
        if (isolationLevelNeeded || definition.isReadOnly()) {
            // empty if block
        }
        entityManager.getTransaction().begin();
        return new SessionTransactionData(session, preparedCon, previousIsolationLevel);
    }

    public ConnectionHandle getJdbcConnection(EntityManager entityManager, boolean readOnly) throws PersistenceException, SQLException {
        return null;
    }

    private static class SessionTransactionData {
        private final Session session;
        @Nullable
        private final Connection preparedCon;
        @Nullable
        private final Integer previousIsolationLevel;

        public SessionTransactionData(Session session, @Nullable Connection preparedCon, @Nullable Integer previousIsolationLevel) {
            this.session = session;
            this.preparedCon = preparedCon;
            this.previousIsolationLevel = previousIsolationLevel;
        }
    }

    private static class MyjpaConnectionHandle
    implements ConnectionHandle {
        private final EntityManager entityManager;
        private Connection connection;

        public MyjpaConnectionHandle(EntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public Connection getConnection() {
            if (this.connection == null) {
                ((Session)this.entityManager.unwrap(Session.class)).getConnection();
            }
            return this.connection;
        }

        public void releaseConnection(Connection con) {
        }
    }
}

