/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.myjpa.data.repository.support;

import cn.sexycode.myjpa.data.repository.support.MyjpaQueryLookupStrategy;
import cn.sexycode.myjpa.data.repository.support.MyjpaRepositoryImpl;
import java.io.Serializable;
import java.util.Optional;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactory;
import org.springframework.data.jpa.repository.support.JpaRepositoryFactoryBean;
import org.springframework.data.jpa.repository.support.JpaRepositoryImplementation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;

public class MyjpaRepositoryFactoryBean
extends JpaRepositoryFactoryBean {
    private final Class repositoryInterface;

    public MyjpaRepositoryFactoryBean(Class repositoryInterface) {
        super(repositoryInterface);
        this.repositoryInterface = repositoryInterface;
    }

    protected RepositoryFactorySupport createRepositoryFactory(EntityManager entityManager) {
        return new MyjpaRepositoryFactory(entityManager);
    }

    private class MyjpaRepositoryFactory<T, I extends Serializable>
    extends JpaRepositoryFactory {
        private final EntityManager em;
        private final QueryExtractor extractor;

        public MyjpaRepositoryFactory(EntityManager em) {
            super(em);
            this.em = em;
            this.extractor = PersistenceProvider.fromEntityManager((EntityManager)em);
        }

        protected JpaRepositoryImplementation<?, ?> getTargetRepository(RepositoryInformation information, EntityManager em) {
            return new MyjpaRepositoryImpl(information.getDomainType(), em, MyjpaRepositoryFactoryBean.this.repositoryInterface);
        }

        protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
            return MyjpaRepositoryImpl.class;
        }

        protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
            return Optional.of(Optional.ofNullable(MyjpaQueryLookupStrategy.create(this.em, key, this.extractor, evaluationContextProvider))).orElse(super.getQueryLookupStrategy(key, evaluationContextProvider));
        }
    }
}

