/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.myjpa.data.repository.support;

import cn.sexycode.myjpa.data.repository.query.MyjpaQueryImpl;
import cn.sexycode.myjpa.data.repository.support.MyjpaQueryMethod;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class MyjpaQueryLookupStrategy {
    private MyjpaQueryLookupStrategy() {
    }

    public static QueryLookupStrategy create(EntityManager em, @Nullable QueryLookupStrategy.Key key, QueryExtractor extractor, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Assert.notNull((Object)em, (String)"EntityManager must not be null!");
        Assert.notNull((Object)extractor, (String)"QueryExtractor must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        switch (key != null ? key : QueryLookupStrategy.Key.USE_DECLARED_QUERY) {
            case USE_DECLARED_QUERY: {
                return new DeclaredQueryLookupStrategy(em, extractor, evaluationContextProvider);
            }
            case CREATE_IF_NOT_FOUND: {
                return new CreateIfNotFoundQueryLookupStrategy(em, extractor, new CreateQueryLookupStrategy(em, extractor), new DeclaredQueryLookupStrategy(em, extractor, evaluationContextProvider));
            }
        }
        return null;
    }

    private static class DeclaredQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;

        public DeclaredQueryLookupStrategy(EntityManager em, QueryExtractor extractor, QueryMethodEvaluationContextProvider evaluationContextProvider) {
            super(em, extractor);
            this.evaluationContextProvider = evaluationContextProvider;
        }

        @Override
        protected RepositoryQuery resolveQuery(MyjpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            return new MyjpaQueryImpl(method, em);
        }
    }

    private static class CreateIfNotFoundQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        public CreateIfNotFoundQueryLookupStrategy(EntityManager em, QueryExtractor extractor, CreateQueryLookupStrategy createStrategy, DeclaredQueryLookupStrategy lookupStrategy) {
            super(em, extractor);
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        @Override
        protected RepositoryQuery resolveQuery(MyjpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            try {
                return this.lookupStrategy.resolveQuery(method, em, namedQueries);
            }
            catch (IllegalStateException e) {
                return this.createStrategy.resolveQuery(method, em, namedQueries);
            }
        }
    }

    private static class CreateQueryLookupStrategy
    extends AbstractQueryLookupStrategy {
        private final PersistenceProvider persistenceProvider;

        public CreateQueryLookupStrategy(EntityManager em, QueryExtractor extractor) {
            super(em, extractor);
            this.persistenceProvider = PersistenceProvider.fromEntityManager((EntityManager)em);
        }

        @Override
        protected RepositoryQuery resolveQuery(MyjpaQueryMethod method, EntityManager em, NamedQueries namedQueries) {
            return null;
        }
    }

    private static abstract class AbstractQueryLookupStrategy
    implements QueryLookupStrategy {
        private final EntityManager em;
        private final QueryExtractor provider;

        public AbstractQueryLookupStrategy(EntityManager em, QueryExtractor extractor) {
            this.em = em;
            this.provider = extractor;
        }

        public final RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            return this.resolveQuery(new MyjpaQueryMethod(method, metadata, factory, this.provider), this.em, namedQueries);
        }

        protected abstract RepositoryQuery resolveQuery(MyjpaQueryMethod var1, EntityManager var2, NamedQueries var3);
    }
}

