/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.util;

import cn.sexycode.mybatis.jpa.util.ColumnNameUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

public class PersistentUtil {
    public static String getTableName(Class<?> clazz) {
        Table table;
        if (clazz.isAnnotationPresent(Table.class) && !(table = clazz.getAnnotation(Table.class)).name().trim().equals("")) {
            return table.name();
        }
        return null;
    }

    public static String getColumnName(Field field) {
        return PersistentUtil.getColumnName(field, true);
    }

    public static String getColumnName(Field field, boolean camelToUnderline) {
        Column column;
        if (field.isAnnotationPresent(Column.class) && !(column = field.getAnnotation(Column.class)).name().trim().equals("")) {
            return column.name().toUpperCase();
        }
        if (!camelToUnderline) {
            return field.getName();
        }
        return ColumnNameUtil.camelToUnderline(field.getName());
    }

    public static String getMappedName(Field field) {
        OneToOne one;
        if (field.isAnnotationPresent(OneToOne.class) && !(one = field.getAnnotation(OneToOne.class)).mappedBy().trim().equals("")) {
            return one.mappedBy();
        }
        if (field.isAnnotationPresent(OneToMany.class) && !(one = field.getAnnotation(OneToMany.class)).mappedBy().trim().equals("")) {
            return one.mappedBy();
        }
        return null;
    }

    public static List<Field> getPersistentFields(Class<?> clazz) {
        ArrayList<Field> list = new ArrayList<Field>();
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (!PersistentUtil.isPersistentField(field)) continue;
                list.add(field);
            }
        }
        return list;
    }

    public static boolean insertable(Field field) {
        if (!PersistentUtil.isPersistentField(field) || PersistentUtil.isAssociationField(field)) {
            return false;
        }
        if (field.isAnnotationPresent(Column.class)) {
            Column column = field.getAnnotation(Column.class);
            return column.insertable();
        }
        return true;
    }

    public static boolean updatable(Field field) {
        if (!PersistentUtil.isPersistentField(field) || PersistentUtil.isAssociationField(field)) {
            return false;
        }
        if (field.isAnnotationPresent(Column.class)) {
            Column column = field.getAnnotation(Column.class);
            return column.updatable();
        }
        return true;
    }

    public static boolean isPersistentField(Field field) {
        return !field.isAnnotationPresent(Transient.class);
    }

    public static boolean isAssociationField(Field field) {
        return field.isAnnotationPresent(OneToOne.class) || field.isAnnotationPresent(OneToMany.class);
    }
}

