/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.session;

import cn.sexycode.mybatis.jpa.MyBatisConfiguration;
import cn.sexycode.mybatis.jpa.binding.BasicTypeRegistration;
import cn.sexycode.mybatis.jpa.binding.ManagedResources;
import cn.sexycode.mybatis.jpa.binding.MappingDefaults;
import cn.sexycode.mybatis.jpa.binding.MappingDefaultsImpl;
import cn.sexycode.mybatis.jpa.binding.Metadata;
import cn.sexycode.mybatis.jpa.binding.MetadataBuildingOptions;
import cn.sexycode.mybatis.jpa.binding.MetadataBuildingProcess;
import cn.sexycode.mybatis.jpa.binding.MetadataSources;
import cn.sexycode.mybatis.jpa.binding.ScanEnvironment;
import cn.sexycode.mybatis.jpa.binding.StandardScanEnvironmentImpl;
import cn.sexycode.mybatis.jpa.service.ServiceRegistry;
import cn.sexycode.mybatis.jpa.service.ServiceRegistryImpl;
import cn.sexycode.mybatis.jpa.session.SessionFactory;
import cn.sexycode.mybatis.jpa.session.SessionFactoryBuilder;
import cn.sexycode.mybatis.jpa.session.SessionFactoryImpl;
import cn.sexycode.sql.dialect.function.SQLFunction;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;

public class SessionFactoryBuilderImpl
implements SessionFactoryBuilder {
    private final PersistenceUnitInfo persistenceUnitInfo;
    private Map properties;
    private Metadata metadata;
    private SqlSessionFactoryBuilder sqlSessionFactoryBuilder = new SqlSessionFactoryBuilder();
    private SqlSessionFactory sqlSessionFactory;

    public SessionFactoryBuilderImpl(PersistenceUnitInfo info, Map properties) {
        this.persistenceUnitInfo = info;
        this.properties = properties;
        this.metadata = this.metadata();
    }

    private Metadata metadata() {
        if (this.metadata == null) {
            MetadataSources metadataSources = new MetadataSources();
            this.persistenceUnitInfo.getManagedClassNames().forEach(managedClassName -> metadataSources.addAnnotatedClassName((String)managedClassName));
            MetadataBuildingOptions options = new MetadataBuildingOptions(){
                private ArrayList<BasicTypeRegistration> basicTypeRegistrations = new ArrayList();
                private HashMap<String, SQLFunction> sqlFunctionMap = new HashMap(1);

                @Override
                public List<BasicTypeRegistration> getBasicTypeRegistrations() {
                    return this.basicTypeRegistrations;
                }

                @Override
                public Object getScanner() {
                    return null;
                }

                @Override
                public Map<String, SQLFunction> getSqlFunctions() {
                    return this.sqlFunctionMap;
                }

                @Override
                public MappingDefaults getMappingDefaults() {
                    return new MappingDefaultsImpl(null);
                }

                @Override
                public ScanEnvironment getScanEnvironment() {
                    return new StandardScanEnvironmentImpl(SessionFactoryBuilderImpl.this.persistenceUnitInfo);
                }

                @Override
                public ServiceRegistry getServiceRegistry() {
                    return new ServiceRegistryImpl();
                }
            };
            ManagedResources managedResources = MetadataBuildingProcess.prepare(metadataSources, options);
            this.metadata = MetadataBuildingProcess.complete(managedResources, options);
        }
        return this.metadata;
    }

    public SessionFactoryBuilder sqlSessionFactory(SqlSessionFactory sqlSessionFactory) {
        this.sqlSessionFactory = sqlSessionFactory;
        return this;
    }

    @Override
    public SessionFactory build(MyBatisConfiguration config) {
        if (Objects.isNull(this.sqlSessionFactory)) {
            this.sqlSessionFactory = this.sqlSessionFactoryBuilder.build((Configuration)config);
        }
        return new SessionFactoryImpl(this.metadata, this.sqlSessionFactory);
    }

    public SessionFactory build(InputStream inputStream, Properties properties) {
        return new SessionFactoryImpl(this.metadata, this.sqlSessionFactoryBuilder.build(inputStream, properties));
    }
}

