/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.session;

import cn.sexycode.mybatis.jpa.binding.ModelProxy;
import cn.sexycode.mybatis.jpa.session.Session;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.apache.ibatis.session.SqlSession;

public class SessionAdaptor {
    private final Session session;
    private static Map<String, Method> methodMapping = new HashMap<String, Method>();

    public SessionAdaptor(Session session) {
        try {
            methodMapping.put("persist", SqlSession.class.getMethod("insert", String.class, Object.class));
            methodMapping.put("merge", SqlSession.class.getMethod("update", String.class, Object.class));
            methodMapping.put("remove", SqlSession.class.getMethod("delete", String.class, Object.class));
            methodMapping.put("find", SqlSession.class.getMethod("selectOne", String.class, Object.class));
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        this.session = session;
    }

    public Object execute(String method, Object ... param) {
        if (param != null && param.length > 0) {
            try {
                Object entity = param[0];
                if (entity.getClass().isAssignableFrom(ModelProxy.class)) {
                    ModelProxy modelProxy = (ModelProxy)entity;
                    return methodMapping.get(method).invoke((Object)this.session.getSession(), modelProxy.getStatement(), modelProxy.getModel());
                }
                return methodMapping.get(method).invoke((Object)this.session.getSession(), entity.getClass().getCanonicalName(), param);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        return param;
    }
}

