/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.session;

import cn.sexycode.mybatis.jpa.session.SessionAdaptor;
import java.io.Closeable;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import org.apache.ibatis.session.SqlSession;

public interface Session
extends EntityManager,
Closeable {
    public static final Logger LOGGER = Logger.getLogger(Session.class.getCanonicalName());

    public SqlSession getSession();

    default public void flush() {
        LOGGER.finer("flush method not support.");
    }

    default public void setFlushMode(FlushModeType flushMode) {
    }

    default public FlushModeType getFlushMode() {
        return null;
    }

    default public void refresh(Object entity) {
        LOGGER.finer("refresh method not support.");
    }

    default public void clear() {
        this.getSession().clearCache();
    }

    @Override
    default public void close() {
        this.getSession().close();
    }

    default public boolean isOpen() {
        return false;
    }

    default public void persist(Object entity) {
        new SessionAdaptor(this).execute("persist", entity);
    }

    default public <T> T merge(T entity) {
        new SessionAdaptor(this).execute("merge", entity);
        return entity;
    }

    default public void remove(Object entity) {
        new SessionAdaptor(this).execute("remove", entity);
    }

    default public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)new SessionAdaptor(this).execute("find", primaryKey);
    }
}

