/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.metamodel.internal;

import cn.sexycode.mybatis.jpa.binding.Metadata;
import cn.sexycode.mybatis.jpa.mapping.PersistentClass;
import cn.sexycode.mybatis.jpa.metamodel.internal.EmbeddableTypeImpl;
import cn.sexycode.mybatis.jpa.metamodel.internal.EntityTypeImpl;
import cn.sexycode.mybatis.jpa.metamodel.internal.MetadataContext;
import cn.sexycode.mybatis.jpa.session.SessionFactory;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityGraph;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MappedSuperclassType;
import javax.persistence.metamodel.Metamodel;

public class MetamodelImpl
implements Metamodel,
Serializable {
    private final Map<String, String> imports = new ConcurrentHashMap<String, String>();
    private final Map<Class, String> entityProxyInterfaceMap = new ConcurrentHashMap<Class, String>();
    private final Map<String, Set<String>> collectionRolesByEntityParticipant = new ConcurrentHashMap<String, Set<String>>();
    private final Map<Class<?>, EntityTypeImpl<?>> jpaEntityTypeMap = new ConcurrentHashMap();
    private final Map<Class<?>, EmbeddableTypeImpl<?>> jpaEmbeddableTypeMap = new ConcurrentHashMap();
    private final Map<Class<?>, MappedSuperclassType<?>> jpaMappedSuperclassTypeMap = new ConcurrentHashMap();
    private final Map<String, EntityTypeImpl<?>> jpaEntityTypesByEntityName = new ConcurrentHashMap();
    private final transient Map<String, EntityGraph> entityGraphMap = new ConcurrentHashMap<String, EntityGraph>();
    private final SessionFactory sessionFactory;

    public MetamodelImpl(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public <X> EntityType<X> entity(Class<X> cls) {
        EntityType entityType = this.jpaEntityTypeMap.get(cls);
        if (entityType == null) {
            throw new IllegalArgumentException("Not an entity: " + cls);
        }
        return entityType;
    }

    public <X> ManagedType<X> managedType(Class<X> cls) {
        ManagedType type = this.jpaEntityTypeMap.get(cls);
        if (type == null) {
            type = (ManagedType)this.jpaMappedSuperclassTypeMap.get(cls);
        }
        if (type == null) {
            type = this.jpaEmbeddableTypeMap.get(cls);
        }
        return type;
    }

    public <X> EmbeddableType<X> embeddable(Class<X> cls) {
        EmbeddableTypeImpl<X> embeddableType = this.jpaEmbeddableTypeMap.get(cls);
        if (embeddableType == null) {
            EmbeddableTypeImpl<X> type = new EmbeddableTypeImpl<X>(cls, null);
            this.jpaEmbeddableTypeMap.put(cls, type);
            embeddableType = type;
        }
        return embeddableType;
    }

    public Set<ManagedType<?>> getManagedTypes() {
        HashSet managedTypes = new HashSet();
        managedTypes.addAll(this.jpaEntityTypeMap.values());
        managedTypes.addAll(this.jpaMappedSuperclassTypeMap.values());
        managedTypes.addAll(this.jpaEmbeddableTypeMap.values());
        return managedTypes;
    }

    public Set<EntityType<?>> getEntities() {
        return new HashSet(this.jpaEntityTypesByEntityName.values());
    }

    public Set<EmbeddableType<?>> getEmbeddables() {
        return new HashSet(this.jpaEmbeddableTypeMap.values());
    }

    public void initialize(Metadata mappingMetadata) {
        MetadataContext context = new MetadataContext(this.sessionFactory, null);
        for (PersistentClass entityBinding : mappingMetadata.getEntityBindings()) {
            MetamodelImpl.locateOrBuildEntityType(entityBinding, context);
        }
        this.jpaEntityTypeMap.putAll(context.getEntityTypeMap());
        this.jpaEmbeddableTypeMap.putAll(context.getEmbeddableTypeMap());
        this.jpaMappedSuperclassTypeMap.putAll(context.getMappedSuperclassTypeMap());
        this.jpaEntityTypesByEntityName.putAll(context.getEntityTypesByEntityName());
    }

    private static EntityTypeImpl<?> locateOrBuildEntityType(PersistentClass persistentClass, MetadataContext context) {
        EntityTypeImpl<?> entityType = context.locateEntityType(persistentClass);
        if (entityType == null) {
            entityType = MetamodelImpl.buildEntityType(persistentClass, context);
        }
        return entityType;
    }

    private static EntityTypeImpl<?> buildEntityType(PersistentClass persistentClass, MetadataContext context) {
        Class javaType = persistentClass.getMappedClass();
        context.pushEntityWorkedOn(persistentClass);
        EntityTypeImpl entityType = new EntityTypeImpl(javaType, null, persistentClass);
        context.registerEntityType(persistentClass, entityType);
        return entityType;
    }
}

