/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.metamodel.internal;

import cn.sexycode.mybatis.jpa.mapping.PersistentClass;
import cn.sexycode.mybatis.jpa.metamodel.internal.AbstractIdentifiableType;
import cn.sexycode.mybatis.jpa.metamodel.internal.AbstractManagedType;
import cn.sexycode.mybatis.jpa.metamodel.internal.EmbeddableTypeImpl;
import cn.sexycode.mybatis.jpa.metamodel.internal.EntityTypeImpl;
import cn.sexycode.mybatis.jpa.metamodel.internal.MappedSuperclassTypeImpl;
import cn.sexycode.mybatis.jpa.session.SessionFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.MappedSuperclass;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.MappedSuperclassType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

class MetadataContext {
    private final SessionFactory sessionFactory;
    private Set<MappedSuperclass> knownMappedSuperclasses;
    private Map<Class<?>, EntityTypeImpl<?>> entityTypes = new HashMap();
    private Map<String, EntityTypeImpl<?>> entityTypesByEntityName = new HashMap();
    private Map<PersistentClass, EntityTypeImpl<?>> entityTypesByPersistentClass = new HashMap();
    private Map<Class<?>, EmbeddableTypeImpl<?>> embeddables = new HashMap();
    private List<Object> orderedMappings = new ArrayList<Object>();
    private List<PersistentClass> stackOfPersistentClassesBeingProcessed = new ArrayList<PersistentClass>();
    private final Set<Class> processedMetamodelClasses = new HashSet<Class>();

    public MetadataContext(SessionFactory sessionFactory, Set<MappedSuperclass> mappedSuperclasses) {
        this.sessionFactory = sessionFactory;
        this.knownMappedSuperclasses = mappedSuperclasses;
    }

    SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Map<Class<?>, EntityTypeImpl<?>> getEntityTypeMap() {
        return Collections.unmodifiableMap(this.entityTypes);
    }

    public Map<Class<?>, EmbeddableTypeImpl<?>> getEmbeddableTypeMap() {
        return Collections.unmodifiableMap(this.embeddables);
    }

    public Map<Class<?>, MappedSuperclassType<?>> getMappedSuperclassTypeMap() {
        HashMap mappedSuperClassTypeMap = new HashMap();
        return mappedSuperClassTypeMap;
    }

    void registerEntityType(PersistentClass persistentClass, EntityTypeImpl<?> entityType) {
        if (entityType.getBindableJavaType() != null) {
            this.entityTypes.put(entityType.getBindableJavaType(), entityType);
        }
        this.entityTypesByEntityName.put(persistentClass.getEntityName(), entityType);
        this.entityTypesByPersistentClass.put(persistentClass, entityType);
        this.orderedMappings.add(persistentClass);
    }

    void registerEmbeddedableType(EmbeddableTypeImpl<?> embeddableType) {
        this.embeddables.put(embeddableType.getJavaType(), embeddableType);
    }

    public EntityTypeImpl<?> locateEntityType(PersistentClass persistentClass) {
        return this.entityTypesByPersistentClass.get(persistentClass);
    }

    public EntityTypeImpl<?> locateEntityType(Class<?> javaType) {
        return this.entityTypes.get(javaType);
    }

    public EntityTypeImpl<?> locateEntityType(String entityName) {
        return this.entityTypesByEntityName.get(entityName);
    }

    public Map<String, EntityTypeImpl<?>> getEntityTypesByEntityName() {
        return Collections.unmodifiableMap(this.entityTypesByEntityName);
    }

    private <X> void applyIdMetadata(PersistentClass persistentClass, EntityTypeImpl<X> jpaEntityType) {
    }

    private <X> void applyIdMetadata(MappedSuperclass mappingType, MappedSuperclassTypeImpl<X> jpaMappingType) {
    }

    private <X> void applyVersionAttribute(PersistentClass persistentClass, EntityTypeImpl<X> jpaEntityType) {
    }

    private <X> void applyVersionAttribute(MappedSuperclass mappingType) {
    }

    private <X> Set<SingularAttribute<? super X, ?>> buildIdClassAttributes(AbstractIdentifiableType<X> ownerType) {
        HashSet attributes = new HashSet();
        return attributes;
    }

    private <X> void populateStaticMetamodel(AbstractManagedType<X> managedType) {
        Class managedTypeClass = managedType.getJavaType();
        if (managedTypeClass == null) {
            return;
        }
        String metamodelClassName = managedTypeClass.getName() + '_';
        try {
            Class<?> metamodelClass = Class.forName(metamodelClassName, true, managedTypeClass.getClassLoader());
            this.registerAttributes(metamodelClass, managedType);
        }
        catch (ClassNotFoundException metamodelClass) {
            // empty catch block
        }
        AbstractManagedType<X> superType = managedType.getSupertype();
        if (superType != null) {
            this.populateStaticMetamodel(superType);
        }
    }

    private <X> void registerAttributes(Class metamodelClass, AbstractManagedType<X> managedType) {
        Set attributes;
        AbstractIdentifiableType entityType;
        if (!this.processedMetamodelClasses.add(metamodelClass)) {
            return;
        }
        for (Attribute<X, ?> attribute : managedType.getDeclaredAttributes()) {
            this.registerAttribute(metamodelClass, attribute);
        }
        if (managedType instanceof IdentifiableType && (entityType = (AbstractIdentifiableType)managedType).hasIdClass() && (attributes = entityType.getIdClassAttributesSafely()) != null) {
            for (SingularAttribute attribute : attributes) {
                this.registerAttribute(metamodelClass, (Attribute<X, ?>)attribute);
            }
        }
    }

    private <X> void registerAttribute(Class metamodelClass, Attribute<X, ?> attribute) {
        String name = attribute.getName();
        try {
            boolean allowNonDeclaredFieldReference = attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED || attribute.getDeclaringType().getPersistenceType() == Type.PersistenceType.EMBEDDABLE;
            Field field = allowNonDeclaredFieldReference ? metamodelClass.getField(name) : metamodelClass.getDeclaredField(name);
            try {
                field.setAccessible(true);
                field.set(null, attribute);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    public void pushEntityWorkedOn(PersistentClass persistentClass) {
        this.stackOfPersistentClassesBeingProcessed.add(persistentClass);
    }

    private PersistentClass getEntityWorkedOn() {
        return this.stackOfPersistentClassesBeingProcessed.get(this.stackOfPersistentClassesBeingProcessed.size() - 1);
    }

    public Set<MappedSuperclass> getUnusedMappedSuperclasses() {
        return new HashSet<MappedSuperclass>(this.knownMappedSuperclasses);
    }
}

