/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.metamodel.internal;

import cn.sexycode.mybatis.jpa.metamodel.internal.AbstractManagedType;
import cn.sexycode.mybatis.jpa.metamodel.internal.BasicTypeImpl;
import cn.sexycode.mybatis.jpa.metamodel.internal.SingularAttributeImpl;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;

public abstract class AbstractIdentifiableType<X>
extends AbstractManagedType<X>
implements IdentifiableType<X>,
Serializable {
    private SingularAttributeImpl<X, ?> id;
    private final boolean hasIdentifierProperty;
    private final boolean hasIdClass;
    private Set<SingularAttribute<? super X, ?>> idClassAttributes;
    private final boolean isVersioned;

    public AbstractIdentifiableType(Class<X> javaType, String typeName, AbstractIdentifiableType<? super X> superType, boolean hasIdClass, boolean hasIdentifierProperty, boolean versioned) {
        super(javaType, typeName, superType);
        this.hasIdClass = hasIdClass;
        this.hasIdentifierProperty = hasIdentifierProperty;
        this.isVersioned = versioned;
        this.id = new SingularAttributeImpl.Identifier("id", this.getIdType().getJavaType(), null, null, this.getIdType(), Attribute.PersistentAttributeType.BASIC);
    }

    public boolean hasIdClass() {
        return this.hasIdClass;
    }

    public boolean hasSingleIdAttribute() {
        return true;
    }

    @Override
    public AbstractIdentifiableType<? super X> getSupertype() {
        return (AbstractIdentifiableType)super.getSupertype();
    }

    public <Y> SingularAttribute<? super X, Y> getId(Class<Y> javaType) {
        this.ensureNoIdClass();
        SingularAttributeImpl id = this.locateIdAttribute();
        if (id != null) {
            this.checkType(id, javaType);
        }
        return id;
    }

    private void ensureNoIdClass() {
        if (this.hasIdClass()) {
            throw new IllegalArgumentException("Illegal call to IdentifiableType#getId for class [" + this.getTypeName() + "] defined with @IdClass");
        }
    }

    private SingularAttributeImpl locateIdAttribute() {
        if (this.id != null) {
            return this.id;
        }
        if (this.getSupertype() != null) {
            SingularAttributeImpl id = ((AbstractIdentifiableType)this.getSupertype()).internalGetId();
            return id;
        }
        return null;
    }

    protected SingularAttributeImpl internalGetId() {
        if (this.id != null) {
            return this.id;
        }
        if (this.getSupertype() != null) {
            return ((AbstractIdentifiableType)this.getSupertype()).internalGetId();
        }
        return null;
    }

    private void checkType(SingularAttributeImpl attribute, Class javaType) {
        if (!javaType.isAssignableFrom(attribute.getType().getJavaType())) {
            throw new IllegalArgumentException(String.format("Attribute [%s#%s : %s] not castable to requested type [%s]", this.getTypeName(), attribute.getName(), attribute.getType().getJavaType().getName(), javaType.getName()));
        }
    }

    public <Y> SingularAttribute<X, Y> getDeclaredId(Class<Y> javaType) {
        return null;
    }

    public Type<?> getIdType() {
        return new BasicTypeImpl<String>(String.class, Type.PersistenceType.BASIC);
    }

    public Set<SingularAttribute<? super X, ?>> getIdClassAttributesSafely() {
        if (!this.hasIdClass()) {
            return null;
        }
        HashSet attributes = new HashSet();
        this.internalCollectIdClassAttributes(attributes);
        if (attributes.isEmpty()) {
            return null;
        }
        return attributes;
    }

    public Set<SingularAttribute<? super X, ?>> getIdClassAttributes() {
        if (!this.hasIdClass()) {
            throw new IllegalArgumentException("This class [" + this.getJavaType() + "] does not define an IdClass");
        }
        HashSet attributes = new HashSet();
        this.internalCollectIdClassAttributes(attributes);
        if (attributes.isEmpty()) {
            // empty if block
        }
        return attributes;
    }

    private void internalCollectIdClassAttributes(Set attributes) {
        if (this.idClassAttributes != null) {
            attributes.addAll(this.idClassAttributes);
        } else if (this.getSupertype() != null) {
            super.internalCollectIdClassAttributes(attributes);
        }
    }

    public boolean hasVersionAttribute() {
        return this.isVersioned;
    }

    public <Y> SingularAttribute<? super X, Y> getVersion(Class<Y> javaType) {
        if (!this.hasVersionAttribute()) {
            return null;
        }
        return null;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredVersion(Class<Y> javaType) {
        this.checkDeclaredVersion();
        return null;
    }

    private void checkDeclaredVersion() {
    }

    public SingularAttribute<X, ?> getDeclaredVersion() {
        return null;
    }
}

