/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.metamodel.internal;

import cn.sexycode.mybatis.jpa.metamodel.internal.AbstractManagedType;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;

public abstract class AbstractAttribute<X, Y>
implements Attribute<X, Y>,
Serializable {
    private final String name;
    private final Class<Y> javaType;
    private final AbstractManagedType<X> declaringType;
    private transient Member member;
    private final Attribute.PersistentAttributeType persistentAttributeType;

    public AbstractAttribute(String name, Class<Y> javaType, AbstractManagedType<X> declaringType, Member member, Attribute.PersistentAttributeType persistentAttributeType) {
        this.name = name;
        this.javaType = javaType;
        this.declaringType = declaringType;
        this.member = member;
        this.persistentAttributeType = persistentAttributeType;
    }

    public String getName() {
        return this.name;
    }

    public ManagedType<X> getDeclaringType() {
        return this.declaringType;
    }

    public Class<Y> getJavaType() {
        return this.javaType;
    }

    public Member getJavaMember() {
        return this.member;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.persistentAttributeType;
    }

    protected void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        String memberDeclaringClassName = (String)ois.readObject();
        String memberName = (String)ois.readObject();
        String memberType = (String)ois.readObject();
        Class<?> memberDeclaringClass = Class.forName(memberDeclaringClassName, false, this.declaringType.getJavaType().getClassLoader());
    }

    protected void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getJavaMember().getDeclaringClass().getName());
        oos.writeObject(this.getJavaMember().getName());
        oos.writeObject(this.getJavaMember() instanceof Method ? "method" : "field");
    }
}

