/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.binding;

import cn.sexycode.mybatis.jpa.binding.ManagedResources;
import cn.sexycode.mybatis.jpa.binding.MetadataBuildingOptions;
import cn.sexycode.mybatis.jpa.binding.MetadataSources;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class ManagedResourcesImpl
implements ManagedResources {
    private Set<Class> annotatedClassReferences = new LinkedHashSet<Class>();
    private Set<String> annotatedClassNames = new LinkedHashSet<String>();
    private Set<String> annotatedPackageNames = new LinkedHashSet<String>();

    public static ManagedResourcesImpl baseline(MetadataSources sources, MetadataBuildingOptions options) {
        ManagedResourcesImpl impl = new ManagedResourcesImpl();
        impl.annotatedClassReferences.addAll(sources.getAnnotatedClasses());
        impl.annotatedClassNames.addAll(sources.getAnnotatedClassNames());
        impl.annotatedPackageNames.addAll(sources.getAnnotatedPackages());
        return impl;
    }

    private ManagedResourcesImpl() {
    }

    @Override
    public Collection<Class> getAnnotatedClassReferences() {
        return Collections.unmodifiableSet(this.annotatedClassReferences);
    }

    @Override
    public Collection<String> getAnnotatedClassNames() {
        return Collections.unmodifiableSet(this.annotatedClassNames);
    }

    @Override
    public Collection<String> getAnnotatedPackageNames() {
        return Collections.unmodifiableSet(this.annotatedPackageNames);
    }

    void addAnnotatedClassReference(Class annotatedClassReference) {
        this.annotatedClassReferences.add(annotatedClassReference);
    }

    void addAnnotatedClassName(String annotatedClassName) {
        this.annotatedClassNames.add(annotatedClassName);
    }

    void addAnnotatedPackageName(String annotatedPackageName) {
        this.annotatedPackageNames.add(annotatedPackageName);
    }
}

