/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.binding;

import cn.sexycode.mybatis.jpa.binding.AnnotatedClassType;
import cn.sexycode.mybatis.jpa.binding.DuplicateMappingException;
import cn.sexycode.mybatis.jpa.binding.IdentifierGeneratorDefinition;
import cn.sexycode.mybatis.jpa.binding.InFlightMetadataCollector;
import cn.sexycode.mybatis.jpa.binding.MappingException;
import cn.sexycode.mybatis.jpa.binding.MetadataBuildingContext;
import cn.sexycode.mybatis.jpa.binding.MetadataBuildingOptions;
import cn.sexycode.mybatis.jpa.binding.MetadataImpl;
import cn.sexycode.mybatis.jpa.mapping.PersistentClass;
import cn.sexycode.mybatis.jpa.session.SessionFactory;
import cn.sexycode.mybatis.jpa.session.SessionFactoryBuilder;
import cn.sexycode.sql.dialect.Dialect;
import cn.sexycode.sql.dialect.function.SQLFunction;
import cn.sexycode.sql.mapping.Column;
import cn.sexycode.sql.mapping.Index;
import cn.sexycode.sql.mapping.Table;
import cn.sexycode.sql.mapping.UniqueKey;
import cn.sexycode.sql.model.Database;
import cn.sexycode.sql.model.Identifier;
import cn.sexycode.sql.model.Namespace;
import cn.sexycode.sql.type.TypeResolver;
import cn.sexycode.util.core.cls.XClass;
import cn.sexycode.util.core.collection.CollectionHelper;
import cn.sexycode.util.core.exception.AnnotationException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InFlightMetadataCollectorImpl
implements InFlightMetadataCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(InFlightMetadataCollectorImpl.class);
    private final MetadataBuildingOptions options;
    private final TypeResolver typeResolver;
    private final UUID uuid;
    private final Map<String, PersistentClass> entityBindingMap = new HashMap<String, PersistentClass>();
    private final Map<String, String> imports = new HashMap<String, String>();
    private Database database;
    private final Map<String, IdentifierGeneratorDefinition> idGeneratorDefinitionMap = new HashMap<String, IdentifierGeneratorDefinition>();
    private Map<String, SQLFunction> sqlFunctionMap;
    private final Set<String> defaultIdentifierGeneratorNames = new HashSet<String>();
    private Map<Class, MappedSuperclass> mappedSuperClasses;
    private Map<Identifier, Identifier> logicalToPhysicalTableNameMap = new HashMap<Identifier, Identifier>();
    private Map<Identifier, Identifier> physicalToLogicalTableNameMap = new HashMap<Identifier, Identifier>();
    private Map<Table, TableColumnNameBinding> columnNameBindingByTableMap;
    private boolean inSecondPass = false;
    private final Map<String, AnnotatedClassType> annotatedClassTypeMap = new HashMap<String, AnnotatedClassType>();

    public InFlightMetadataCollectorImpl(MetadataBuildingOptions options, TypeResolver typeResolver) {
        this.uuid = UUID.randomUUID();
        this.options = options;
        this.typeResolver = typeResolver;
        for (Map.Entry<String, SQLFunction> sqlFunctionEntry : options.getSqlFunctions().entrySet()) {
            if (this.sqlFunctionMap == null) {
                this.sqlFunctionMap = new ConcurrentHashMap<String, SQLFunction>(16, 0.75f, 1);
            }
            this.sqlFunctionMap.put(sqlFunctionEntry.getKey(), sqlFunctionEntry.getValue());
        }
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public MetadataBuildingOptions getMetadataBuildingOptions() {
        return this.options;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public Database getDatabase() {
        if (this.database == null) {
            this.database = new Database(null);
        }
        return this.database;
    }

    @Override
    public Map<String, SQLFunction> getSqlFunctionMap() {
        return this.sqlFunctionMap;
    }

    @Override
    public void validate() throws MappingException {
    }

    @Override
    public Set<MappedSuperclass> getMappedSuperclassMappingsCopy() {
        return new HashSet<MappedSuperclass>(this.mappedSuperClasses.values());
    }

    @Override
    public SessionFactoryBuilder getSessionFactoryBuilder() {
        throw new UnsupportedOperationException("You should not be building a SessionFactory from an in-flight metadata collector; and of course we should better segment this in the API :)");
    }

    @Override
    public SessionFactory buildSessionFactory() {
        throw new UnsupportedOperationException("You should not be building a SessionFactory from an in-flight metadata collector; and of course we should better segment this in the API :)");
    }

    @Override
    public Collection<PersistentClass> getEntityBindings() {
        return this.entityBindingMap.values();
    }

    @Override
    public Map<String, PersistentClass> getEntityBindingMap() {
        return this.entityBindingMap;
    }

    @Override
    public PersistentClass getEntityBinding(String entityName) {
        return this.entityBindingMap.get(entityName);
    }

    @Override
    public void addEntityBinding(PersistentClass persistentClass) throws DuplicateMappingException {
        String entityName = persistentClass.getEntityName();
        if (this.entityBindingMap.containsKey(entityName)) {
            throw new DuplicateMappingException(DuplicateMappingException.Type.ENTITY, entityName);
        }
        this.entityBindingMap.put(entityName, persistentClass);
    }

    public IdentifierGeneratorDefinition getIdentifierGenerator(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null is not a valid generator name");
        }
        return this.idGeneratorDefinitionMap.get(name);
    }

    public Collection<Table> collectTableMappings() {
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Namespace namespace : this.getDatabase().getNamespaces()) {
            tables.addAll(namespace.getTables());
        }
        return tables;
    }

    @Override
    public void addIdentifierGenerator(IdentifierGeneratorDefinition generator) {
        if (generator == null || generator.getName() == null) {
            throw new IllegalArgumentException("ID generator object or name is null.");
        }
        if (this.defaultIdentifierGeneratorNames.contains(generator.getName())) {
            return;
        }
        IdentifierGeneratorDefinition old = this.idGeneratorDefinitionMap.put(generator.getName(), generator);
    }

    @Override
    public void addDefaultIdentifierGenerator(IdentifierGeneratorDefinition generator) {
        this.addIdentifierGenerator(generator);
        this.defaultIdentifierGeneratorNames.add(generator.getName());
    }

    @Override
    public Map<String, String> getImports() {
        return this.imports;
    }

    @Override
    public void addImport(String importName, String entityName) {
        if (importName == null || entityName == null) {
            throw new IllegalArgumentException("Import name or entity name is null");
        }
        LOGGER.trace("Import: {0} -> {1}", (Object)importName, (Object)entityName);
        String old = this.imports.put(importName, entityName);
        if (old != null) {
            LOGGER.debug("import name [" + importName + "] overrode previous [{" + old + "}]");
        }
    }

    @Override
    public Table addTable(String schemaName, String catalogName, String name, String subselectFragment, boolean isAbstract) {
        Namespace namespace = this.getDatabase().locateNamespace(this.getDatabase().toIdentifier(catalogName), this.getDatabase().toIdentifier(schemaName));
        Identifier logicalName = name != null ? this.getDatabase().toIdentifier(name) : null;
        if (subselectFragment != null) {
            return new Table(namespace, logicalName, isAbstract);
        }
        Table table = namespace.locateTable(logicalName);
        if (table != null) {
            if (!isAbstract) {
                table.setAbstract(false);
            }
            return table;
        }
        return namespace.createTable(logicalName, isAbstract);
    }

    @Override
    public void addTableNameBinding(Identifier logicalName, Table table) {
        this.logicalToPhysicalTableNameMap.put(logicalName, table.getNameIdentifier());
        this.physicalToLogicalTableNameMap.put(table.getNameIdentifier(), logicalName);
    }

    @Override
    public void addTableNameBinding(String schema, String catalog, String logicalName, String realTableName, Table denormalizedSuperTable) {
        Identifier logicalNameIdentifier = this.getDatabase().toIdentifier(logicalName);
        Identifier physicalNameIdentifier = this.getDatabase().toIdentifier(realTableName);
        this.logicalToPhysicalTableNameMap.put(logicalNameIdentifier, physicalNameIdentifier);
        this.physicalToLogicalTableNameMap.put(physicalNameIdentifier, logicalNameIdentifier);
    }

    @Override
    public String getLogicalTableName(Table ownerTable) {
        Identifier logicalName = this.physicalToLogicalTableNameMap.get(ownerTable.getNameIdentifier());
        if (logicalName == null) {
            throw new MappingException("Unable to find physical table: " + ownerTable.getName());
        }
        return logicalName.render();
    }

    @Override
    public String getPhysicalTableName(Identifier logicalName) {
        Identifier physicalName = this.logicalToPhysicalTableNameMap.get(logicalName);
        return physicalName == null ? null : physicalName.render();
    }

    @Override
    public String getPhysicalTableName(String logicalName) {
        return this.getPhysicalTableName(this.getDatabase().toIdentifier(logicalName));
    }

    @Override
    public void addColumnNameBinding(Table table, String logicalName, Column column) throws DuplicateMappingException {
        this.addColumnNameBinding(table, this.getDatabase().toIdentifier(logicalName), column);
    }

    @Override
    public void addColumnNameBinding(Table table, Identifier logicalName, Column column) throws DuplicateMappingException {
        TableColumnNameBinding binding = null;
        if (this.columnNameBindingByTableMap == null) {
            this.columnNameBindingByTableMap = new HashMap<Table, TableColumnNameBinding>();
        } else {
            binding = this.columnNameBindingByTableMap.get(table);
        }
        if (binding == null) {
            binding = new TableColumnNameBinding(table.getName());
            this.columnNameBindingByTableMap.put(table, binding);
        }
        binding.addBinding(logicalName, column);
    }

    @Override
    public String getPhysicalColumnName(Table table, String logicalName) throws MappingException {
        return this.getPhysicalColumnName(table, this.getDatabase().toIdentifier(logicalName));
    }

    @Override
    public String getPhysicalColumnName(Table table, Identifier logicalName) throws MappingException {
        TableColumnNameBinding binding;
        if (logicalName == null) {
            throw new MappingException("Logical column name cannot be null");
        }
        Table currentTable = table;
        String physicalName = null;
        while (currentTable != null && ((binding = this.columnNameBindingByTableMap.get(currentTable)) == null || (physicalName = (String)binding.logicalToPhysical.get(logicalName)) == null)) {
        }
        if (physicalName == null) {
            throw new MappingException("Unable to find column with logical name " + logicalName.render() + " in table " + table.getName());
        }
        return physicalName;
    }

    @Override
    public String getLogicalColumnName(Table table, String physicalName) throws MappingException {
        return this.getLogicalColumnName(table, this.getDatabase().toIdentifier(physicalName));
    }

    @Override
    public String getLogicalColumnName(Table table, Identifier physicalName) throws MappingException {
        TableColumnNameBinding binding;
        String physicalNameString = physicalName.render(this.getDatabase().getEnvironment().getDialect());
        Identifier logicalName = null;
        Table currentTable = table;
        while (currentTable != null && ((binding = this.columnNameBindingByTableMap.get(currentTable)) == null || (logicalName = (Identifier)binding.physicalToLogical.get(physicalNameString)) == null)) {
        }
        if (logicalName == null) {
            throw new MappingException("Unable to find column with physical name " + physicalNameString + " in table " + table.getName());
        }
        return logicalName.render();
    }

    @Override
    public void addMappedSuperclass(Class type, MappedSuperclass mappedSuperclass) {
        if (this.mappedSuperClasses == null) {
            this.mappedSuperClasses = new HashMap<Class, MappedSuperclass>();
        }
        this.mappedSuperClasses.put(type, mappedSuperclass);
    }

    @Override
    public MappedSuperclass getMappedSuperclass(Class type) {
        if (this.mappedSuperClasses == null) {
            return null;
        }
        return this.mappedSuperClasses.get(type);
    }

    private List<Identifier> toIdentifiers(String[] names) {
        if (names == null) {
            return Collections.emptyList();
        }
        ArrayList columnNames = CollectionHelper.arrayList((int)names.length);
        for (String name : names) {
            columnNames.add(this.getDatabase().toIdentifier(name));
        }
        return columnNames;
    }

    private List<Identifier> extractColumnNames(List columns) {
        if (columns == null || columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList columnNames = CollectionHelper.arrayList((int)columns.size());
        for (Column column : columns) {
            columnNames.add(this.getDatabase().toIdentifier(column.getQuotedName()));
        }
        return columnNames;
    }

    private void buildUniqueKeyFromColumnNames(Table table, String keyName, String[] columnNames, MetadataBuildingContext buildingContext) {
        this.buildUniqueKeyFromColumnNames(table, keyName, columnNames, null, true, buildingContext);
    }

    private void buildUniqueKeyFromColumnNames(Table table, String keyName, String[] columnNames, String[] orderings, boolean unique, MetadataBuildingContext buildingContext) {
        String order;
        Column column;
        int i;
        int size = columnNames.length;
        Column[] columns = new Column[size];
        HashSet<Column> unbound = new HashSet<Column>();
        HashSet<Column> unboundNoLogical = new HashSet<Column>();
        for (int index = 0; index < size; ++index) {
            String logicalColumnName = columnNames[index];
            try {
                String physicalColumnName = this.getPhysicalColumnName(table, logicalColumnName);
                columns[index] = new Column(physicalColumnName);
                unbound.add(columns[index]);
                continue;
            }
            catch (MappingException e) {
                columns[index] = new Column(logicalColumnName);
                unboundNoLogical.add(columns[index]);
            }
        }
        String originalKeyName = keyName;
        if (unique) {
            UniqueKey uk = table.getOrCreateUniqueKey(keyName);
            for (i = 0; i < columns.length; ++i) {
                column = columns[i];
                String string = order = orderings != null ? orderings[i] : null;
                if (!table.containsColumn(column)) continue;
                uk.addColumn(column, order);
                unbound.remove(column);
            }
        } else {
            Index index = table.getOrCreateIndex(keyName);
            for (i = 0; i < columns.length; ++i) {
                column = columns[i];
                String string = order = orderings != null ? orderings[i] : null;
                if (!table.containsColumn(column)) continue;
                index.addColumn(column, order);
                unbound.remove(column);
            }
        }
        if (unbound.size() > 0 || unboundNoLogical.size() > 0) {
            StringBuilder sb = new StringBuilder("Unable to create ");
            if (unique) {
                sb.append("unique key constraint (");
            } else {
                sb.append("index (");
            }
            for (String columnName : columnNames) {
                sb.append(columnName).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(") on table ").append(table.getName()).append(": database column ");
            for (Column column2 : unbound) {
                sb.append("'").append(column2.getName()).append("', ");
            }
            for (Column column3 : unboundNoLogical) {
                sb.append("'").append(column3.getName()).append("', ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" not found. Make sure that you use the correct column name which depends on the naming strategy in use (it may not be the same as the property name in the entity, especially for relational types)");
            throw new AnnotationException(sb.toString());
        }
    }

    @Override
    public boolean isInSecondPass() {
        return this.inSecondPass;
    }

    @Override
    public void addUniqueConstraints(Table table, List uniqueConstraints) {
    }

    public MetadataImpl buildMetadataInstance(MetadataBuildingContext buildingContext) {
        this.processExportableProducers(buildingContext);
        return new MetadataImpl(this.uuid, this.options, this.typeResolver, this.entityBindingMap, this.mappedSuperClasses, this.sqlFunctionMap, this.getDatabase());
    }

    private void processExportableProducers(MetadataBuildingContext buildingContext) {
    }

    private String extractName(Identifier identifier, Dialect dialect) {
        if (identifier == null) {
            return null;
        }
        return identifier.render(dialect);
    }

    @Override
    public AnnotatedClassType getClassType(XClass clazz) {
        AnnotatedClassType type = this.annotatedClassTypeMap.get(clazz.getName());
        if (type == null) {
            return this.addClassType(clazz);
        }
        return type;
    }

    @Override
    public AnnotatedClassType addClassType(XClass clazz) {
        AnnotatedClassType type = clazz.isAnnotationPresent(Entity.class) ? AnnotatedClassType.ENTITY : (clazz.isAnnotationPresent(Embeddable.class) ? AnnotatedClassType.EMBEDDABLE : (clazz.isAnnotationPresent(MappedSuperclass.class) ? AnnotatedClassType.EMBEDDABLE_SUPERCLASS : AnnotatedClassType.NONE));
        this.annotatedClassTypeMap.put(clazz.getName(), type);
        return type;
    }

    private class TableColumnNameBinding
    implements Serializable {
        private final String tableName;
        private Map<Identifier, String> logicalToPhysical = new HashMap<Identifier, String>();
        private Map<String, Identifier> physicalToLogical = new HashMap<String, Identifier>();

        private TableColumnNameBinding(String tableName) {
            this.tableName = tableName;
        }

        public void addBinding(Identifier logicalName, Column physicalColumn) {
            String physicalNameString = physicalColumn.getQuotedName(InFlightMetadataCollectorImpl.this.getDatabase().getEnvironment().getDialect());
            this.bindLogicalToPhysical(logicalName, physicalNameString);
            this.bindPhysicalToLogical(logicalName, physicalNameString);
        }

        private void bindLogicalToPhysical(Identifier logicalName, String physicalName) throws DuplicateMappingException {
            String existingPhysicalNameMapping = this.logicalToPhysical.put(logicalName, physicalName);
            if (existingPhysicalNameMapping != null) {
                boolean areSame;
                boolean bl = areSame = logicalName.isQuoted() ? physicalName.equals(existingPhysicalNameMapping) : physicalName.equalsIgnoreCase(existingPhysicalNameMapping);
                if (!areSame) {
                    throw new DuplicateMappingException(String.format(Locale.ENGLISH, "Table [%s] contains logical column name [%s] referring to multiple physical column names: [%s], [%s]", this.tableName, logicalName, existingPhysicalNameMapping, physicalName), DuplicateMappingException.Type.COLUMN_BINDING, this.tableName + "." + logicalName);
                }
            }
        }

        private void bindPhysicalToLogical(Identifier logicalName, String physicalName) throws DuplicateMappingException {
            Identifier existingLogicalName = this.physicalToLogical.put(physicalName, logicalName);
            if (existingLogicalName != null && !existingLogicalName.equals((Object)logicalName)) {
                throw new DuplicateMappingException(String.format(Locale.ENGLISH, "Table [%s] contains physical column name [%s] referred to by multiple physical column names: [%s], [%s]", this.tableName, physicalName, logicalName, existingLogicalName), DuplicateMappingException.Type.COLUMN_BINDING, this.tableName + "." + physicalName);
            }
        }
    }
}

