/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.binding;

import cn.sexycode.mybatis.jpa.Configuration;
import cn.sexycode.mybatis.jpa.binding.EntityColumn;
import cn.sexycode.mybatis.jpa.binding.EntityField;
import cn.sexycode.mybatis.jpa.binding.EntityTable;
import cn.sexycode.mybatis.jpa.binding.FieldHelper;
import cn.sexycode.mybatis.jpa.binding.MappingException;
import cn.sexycode.util.core.str.StringHelper;
import cn.sexycode.util.core.str.Style;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;

public class EntityHelper {
    private static final Map<Class<?>, EntityTable> entityTableMap = new ConcurrentHashMap();

    public static EntityTable getEntityTable(Class<?> entityClass) {
        EntityTable entityTable = entityTableMap.get(entityClass);
        if (entityTable == null) {
            throw new MappingException("\u65e0\u6cd5\u83b7\u53d6\u5b9e\u4f53\u7c7b" + entityClass.getCanonicalName() + "\u5bf9\u5e94\u7684\u8868\u540d!");
        }
        return entityTable;
    }

    public static String getOrderByClause(Class<?> entityClass) {
        EntityTable table = EntityHelper.getEntityTable(entityClass);
        if (table.getOrderByClause() != null) {
            return table.getOrderByClause();
        }
        StringBuilder orderBy = new StringBuilder();
        for (EntityColumn column : table.getEntityClassColumns()) {
            if (column.getOrderBy() == null) continue;
            if (orderBy.length() != 0) {
                orderBy.append(",");
            }
            orderBy.append(column.getColumn()).append(" ").append(column.getOrderBy());
        }
        table.setOrderByClause(orderBy.toString());
        return table.getOrderByClause();
    }

    public static Set<EntityColumn> getColumns(Class<?> entityClass) {
        return EntityHelper.getEntityTable(entityClass).getEntityClassColumns();
    }

    public static Set<EntityColumn> getPKColumns(Class<?> entityClass) {
        return EntityHelper.getEntityTable(entityClass).getEntityClassPKColumns();
    }

    public static String getSelectColumns(Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        if (entityTable.getBaseSelect() != null) {
            return entityTable.getBaseSelect();
        }
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        boolean skipAlias = Map.class.isAssignableFrom(entityClass);
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn());
            if (!skipAlias && !entityColumn.getColumn().equalsIgnoreCase(entityColumn.getProperty())) {
                if (entityColumn.getColumn().substring(1, entityColumn.getColumn().length() - 1).equalsIgnoreCase(entityColumn.getProperty())) {
                    selectBuilder.append(",");
                    continue;
                }
                selectBuilder.append(" AS ").append(entityColumn.getProperty()).append(",");
                continue;
            }
            selectBuilder.append(",");
        }
        entityTable.setBaseSelect(selectBuilder.substring(0, selectBuilder.length() - 1));
        return entityTable.getBaseSelect();
    }

    @Deprecated
    public static String getAllColumns(Class<?> entityClass) {
        Set<EntityColumn> columnList = EntityHelper.getColumns(entityClass);
        StringBuilder selectBuilder = new StringBuilder();
        for (EntityColumn entityColumn : columnList) {
            selectBuilder.append(entityColumn.getColumn()).append(",");
        }
        return selectBuilder.substring(0, selectBuilder.length() - 1);
    }

    @Deprecated
    public static String getPrimaryKeyWhere(Class<?> entityClass) {
        Set<EntityColumn> entityColumns = EntityHelper.getPKColumns(entityClass);
        StringBuilder whereBuilder = new StringBuilder();
        for (EntityColumn column : entityColumns) {
            whereBuilder.append(column.getColumnEqualsHolder()).append(" AND ");
        }
        return whereBuilder.substring(0, whereBuilder.length() - 4);
    }

    public static synchronized void initEntityNameMap(Class<?> entityClass, Configuration configuration) {
        Table table;
        if (entityTableMap.get(entityClass) != null) {
            return;
        }
        Style style = configuration.getStyle();
        EntityTable entityTable = null;
        if (entityClass.isAnnotationPresent(Table.class) && !(table = entityClass.getAnnotation(Table.class)).name().equals("")) {
            entityTable = new EntityTable(entityClass);
            entityTable.setTable(table);
        }
        if (entityTable == null) {
            entityTable = new EntityTable(entityClass);
            entityTable.setName(StringHelper.convertByStyle((String)entityClass.getSimpleName(), (Style)style));
        }
        entityTable.setEntityClassColumns(new LinkedHashSet<EntityColumn>());
        entityTable.setEntityClassPKColumns(new LinkedHashSet<EntityColumn>());
        List<EntityField> fields = null;
        fields = configuration.isEnableMethodAnnotation() ? FieldHelper.getAll(entityClass) : FieldHelper.getFields(entityClass);
        for (EntityField field : fields) {
            EntityHelper.processField(entityTable, style, field, configuration.getWrapKeyword());
        }
        if (entityTable.getEntityClassPKColumns().size() == 0) {
            entityTable.setEntityClassPKColumns(entityTable.getEntityClassColumns());
        }
        entityTable.initPropertyMap();
        entityTableMap.put(entityClass, entityTable);
    }

    private static void processField(EntityTable entityTable, Style style, EntityField field, String wrapKeyword) {
        if (field.isAnnotationPresent(Transient.class)) {
            return;
        }
        EntityColumn entityColumn = new EntityColumn(entityTable);
        entityColumn.setEntityField(field);
        if (field.isAnnotationPresent(Id.class)) {
            entityColumn.setId(true);
        }
        String columnName = null;
        if (field.isAnnotationPresent(Column.class)) {
            Column column = field.getAnnotation(Column.class);
            columnName = column.name();
            entityColumn.setUpdatable(column.updatable());
            entityColumn.setInsertable(column.insertable());
        }
        if (StringHelper.isEmpty(columnName)) {
            columnName = StringHelper.convertByStyle((String)field.getName(), (Style)style);
        }
        entityColumn.setProperty(field.getName());
        entityColumn.setColumn(columnName);
        entityColumn.setJavaType(field.getJavaType());
        if (field.isAnnotationPresent(OrderBy.class)) {
            OrderBy orderBy = field.getAnnotation(OrderBy.class);
            if (orderBy.value().equals("")) {
                entityColumn.setOrderBy("ASC");
            } else {
                entityColumn.setOrderBy(orderBy.value());
            }
        }
        if (field.isAnnotationPresent(SequenceGenerator.class)) {
            SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
            if (sequenceGenerator.sequenceName().equals("")) {
                throw new MappingException(entityTable.getEntityClass() + "\u5b57\u6bb5" + field.getName() + "\u7684\u6ce8\u89e3@SequenceGenerator\u672a\u6307\u5b9asequenceName!");
            }
            entityColumn.setSequenceName(sequenceGenerator.sequenceName());
        } else if (field.isAnnotationPresent(GeneratedValue.class)) {
            GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
            if (generatedValue.generator().equals("UUID")) {
                entityColumn.setUuid(true);
            } else if (generatedValue.generator().equals("JDBC")) {
                entityColumn.setIdentity(true);
                entityColumn.setGenerator("JDBC");
                entityTable.setKeyProperties(entityColumn.getProperty());
                entityTable.setKeyColumns(entityColumn.getColumn());
            } else if (generatedValue.strategy() == GenerationType.IDENTITY) {
                entityColumn.setIdentity(true);
                if (!generatedValue.generator().equals("")) {
                    String generator = null;
                    entityColumn.setGenerator(generator);
                }
            } else {
                throw new MappingException(field.getName() + " - \u8be5\u5b57\u6bb5@GeneratedValue\u914d\u7f6e\u53ea\u5141\u8bb8\u4ee5\u4e0b\u51e0\u79cd\u5f62\u5f0f:\n1.\u5168\u90e8\u6570\u636e\u5e93\u901a\u7528\u7684@GeneratedValue(generator=\"UUID\")\n2.useGeneratedKeys\u7684@GeneratedValue(generator=\\\"JDBC\\\")  \n3.\u7c7b\u4f3cmysql\u6570\u636e\u5e93\u7684@GeneratedValue(strategy=GenerationType.IDENTITY[,generator=\"Mysql\"])");
            }
        }
        entityTable.getEntityClassColumns().add(entityColumn);
        if (entityColumn.isId()) {
            entityTable.getEntityClassPKColumns().add(entityColumn);
        }
    }
}

