/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.binding;

import cn.sexycode.mybatis.jpa.binding.InheritanceState;
import cn.sexycode.mybatis.jpa.binding.MappingException;
import cn.sexycode.mybatis.jpa.binding.MetadataBuildingContext;
import cn.sexycode.mybatis.jpa.mapping.PersistentClass;
import cn.sexycode.mybatis.jpa.mapping.RootClass;
import cn.sexycode.util.core.cls.XClass;
import cn.sexycode.util.core.exception.AnnotationException;
import cn.sexycode.util.core.str.StringHelper;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.criteria.Join;
import jdk.nashorn.internal.ir.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBinder {
    private static final Logger LOG = LoggerFactory.getLogger(EntityBinder.class);
    private static final String NATURAL_ID_CACHE_SUFFIX = "##NaturalId";
    private MetadataBuildingContext context;
    private String name;
    private XClass annotatedClass;
    private PersistentClass persistentClass;
    private String discriminatorValue = "";
    private Boolean forceDiscriminator;
    private Boolean insertableDiscriminator;
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private boolean explicitHibernateEntityAnnotation;
    private boolean selectBeforeUpdate;
    private int batchSize;
    private boolean lazy;
    private XClass proxyClass;
    private String where;
    private Map<String, Join> secondaryTables = new HashMap<String, Join>();
    private Map<String, Object> secondaryTableJoins = new HashMap<String, Object>();
    private InheritanceState inheritanceState;
    private boolean ignoreIdAnnotations;
    private boolean wrapIdsInEmbeddedComponents;
    private String subselect;
    private boolean isCached;
    private String cacheConcurrentStrategy;
    private String cacheRegion;
    private boolean cacheLazyProperty;
    private String naturalIdCacheRegion;

    public boolean wrapIdsInEmbeddedComponents() {
        return this.wrapIdsInEmbeddedComponents;
    }

    public EntityBinder() {
    }

    public EntityBinder(Entity hibAnn, XClass annotatedClass, PersistentClass persistentClass, MetadataBuildingContext context) {
        this.context = context;
        this.persistentClass = persistentClass;
        this.annotatedClass = annotatedClass;
    }

    public boolean isRootEntity() {
        return this.persistentClass instanceof RootClass;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void setForceDiscriminator(boolean forceDiscriminator) {
        this.forceDiscriminator = forceDiscriminator;
    }

    public void setInsertableDiscriminator(boolean insertableDiscriminator) {
        this.insertableDiscriminator = insertableDiscriminator;
    }

    public void bindEntity() {
        this.persistentClass.setClassName(this.annotatedClass.getName());
        this.persistentClass.setJpaEntityName(this.name);
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        this.bindDiscriminatorValue();
        if (this.proxyClass != null) {
            this.persistentClass.setProxyInterfaceName(this.proxyClass.getName());
        }
        this.persistentClass.setDynamicInsert(this.dynamicInsert);
        this.persistentClass.setDynamicUpdate(this.dynamicUpdate);
        if (this.persistentClass instanceof RootClass) {
            RootClass rootClass = (RootClass)this.persistentClass;
            boolean mutable = true;
            if (this.annotatedClass.isAnnotationPresent(Immutable.class)) {
                mutable = false;
            } else {
                Entity entity = (Entity)this.annotatedClass.getAnnotation(Entity.class);
            }
            if (StringHelper.isNotEmpty((String)this.where)) {
                // empty if block
            }
        }
        LOG.debug("Import with entity name %s", (Object)this.name);
        try {
            this.context.getMetadataCollector().addImport(this.name, this.persistentClass.getEntityName());
            String entityName = this.persistentClass.getEntityName();
            if (!entityName.equals(this.name)) {
                this.context.getMetadataCollector().addImport(entityName, entityName);
            }
        }
        catch (MappingException me) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name, (Throwable)((Object)me));
        }
        this.processNamedEntityGraphs();
    }

    private void processNamedEntityGraphs() {
        this.processNamedEntityGraph((NamedEntityGraph)this.annotatedClass.getAnnotation(NamedEntityGraph.class));
        NamedEntityGraphs graphs = (NamedEntityGraphs)this.annotatedClass.getAnnotation(NamedEntityGraphs.class);
        if (graphs != null) {
            for (NamedEntityGraph graph : graphs.value()) {
                this.processNamedEntityGraph(graph);
            }
        }
    }

    private void processNamedEntityGraph(NamedEntityGraph annotation) {
        if (annotation == null) {
            return;
        }
    }

    public void bindDiscriminatorValue() {
    }

    public void setWrapIdsInEmbeddedComponents(boolean wrapIdsInEmbeddedComponents) {
        this.wrapIdsInEmbeddedComponents = wrapIdsInEmbeddedComponents;
    }

    public Map<String, Join> getSecondaryTables() {
        return this.secondaryTables;
    }

    public void setInheritanceState(InheritanceState inheritanceState) {
        this.inheritanceState = inheritanceState;
    }
}

