/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.binding;

import cn.sexycode.mybatis.jpa.binding.AnnotationBinder;
import cn.sexycode.mybatis.jpa.binding.InheritanceState;
import cn.sexycode.mybatis.jpa.binding.ManagedResources;
import cn.sexycode.mybatis.jpa.binding.MetadataBuildingContextRootImpl;
import cn.sexycode.mybatis.jpa.binding.SimpleMetadataSourceProcessorImpl;
import cn.sexycode.util.core.cls.ReflectionManager;
import cn.sexycode.util.core.cls.XClass;
import cn.sexycode.util.core.cls.internal.JavaReflectionManager;
import cn.sexycode.util.core.collection.CollectionHelper;
import cn.sexycode.util.core.exception.AnnotationException;
import cn.sexycode.util.core.exception.ClassLoadingException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Converter;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationMetadataSourceProcessorImpl
extends SimpleMetadataSourceProcessorImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotationMetadataSourceProcessorImpl.class);
    private final MetadataBuildingContextRootImpl rootMetadataBuildingContext;
    private final LinkedHashSet<String> annotatedPackages = new LinkedHashSet();
    private final ReflectionManager reflectionManager;
    private final List<XClass> xClasses = new ArrayList<XClass>();

    public AnnotationMetadataSourceProcessorImpl(ManagedResources managedResources, MetadataBuildingContextRootImpl rootMetadataBuildingContext) {
        this.rootMetadataBuildingContext = rootMetadataBuildingContext;
        this.reflectionManager = new JavaReflectionManager();
        if (CollectionHelper.isNotEmpty(managedResources.getAnnotatedPackageNames())) {
            this.annotatedPackages.addAll(managedResources.getAnnotatedPackageNames());
        }
        for (String className : managedResources.getAnnotatedClassNames()) {
            try {
                Class<?> annotatedClass = Class.forName(className);
                this.categorizeAnnotatedClass(annotatedClass);
            }
            catch (ClassNotFoundException e) {
                LOGGER.warn("ClassNotFound", (Throwable)e);
            }
        }
        for (Class annotatedClass : managedResources.getAnnotatedClassReferences()) {
            this.categorizeAnnotatedClass(annotatedClass);
        }
    }

    private void categorizeAnnotatedClass(Class annotatedClass) {
        XClass xClass = this.reflectionManager.toXClass(annotatedClass);
        if (!xClass.isAnnotationPresent(Converter.class)) {
            if (xClass.isAnnotationPresent(Entity.class) || xClass.isAnnotationPresent(MappedSuperclass.class)) {
                this.xClasses.add(xClass);
            } else if (xClass.isAnnotationPresent(Embeddable.class)) {
                this.xClasses.add(xClass);
            } else {
                LOGGER.debug("Encountered a non-categorized annotated class [%s]; ignoring", (Object)annotatedClass.getName());
            }
        }
    }

    private XClass toXClass(String className, ReflectionManager reflectionManager) {
        try {
            return reflectionManager.classForName(className);
        }
        catch (ClassLoadingException e) {
            throw new AnnotationException("Unable to load class defined in XML: " + className, (Throwable)e);
        }
    }

    @Override
    public void prepare() {
        AnnotationBinder.bindDefaults(this.rootMetadataBuildingContext);
        for (String annotatedPackage : this.annotatedPackages) {
            AnnotationBinder.bindPackage(annotatedPackage, this.rootMetadataBuildingContext);
        }
    }

    @Override
    public void processEntityHierarchies(Set<String> processedEntityNames) {
        List<XClass> orderedClasses = this.orderAndFillHierarchy(this.xClasses);
        Map<XClass, InheritanceState> inheritanceStatePerClass = AnnotationBinder.buildInheritanceStates(orderedClasses, this.rootMetadataBuildingContext);
        for (XClass clazz : orderedClasses) {
            if (processedEntityNames.contains(clazz.getName())) {
                LOGGER.debug("Skipping annotated class processing of entity [%s], as it has already been processed", (Object)clazz);
                continue;
            }
            AnnotationBinder.bindClass(clazz, inheritanceStatePerClass, this.rootMetadataBuildingContext);
            processedEntityNames.add(clazz.getName());
        }
    }

    private List<XClass> orderAndFillHierarchy(List<XClass> original) {
        ArrayList<XClass> copy = new ArrayList<XClass>(original);
        this.insertMappedSuperclasses(original, copy);
        ArrayList<XClass> workingCopy = new ArrayList<XClass>(copy);
        ArrayList<XClass> newList = new ArrayList<XClass>(copy.size());
        while (workingCopy.size() > 0) {
            XClass clazz = (XClass)workingCopy.get(0);
            this.orderHierarchy(workingCopy, newList, copy, clazz);
        }
        return newList;
    }

    private void insertMappedSuperclasses(List<XClass> original, List<XClass> copy) {
        for (XClass clazz : original) {
            for (XClass superClass = clazz.getSuperclass(); superClass != null && !this.reflectionManager.equals(superClass, Object.class) && !copy.contains(superClass); superClass = superClass.getSuperclass()) {
                if (!superClass.isAnnotationPresent(Entity.class) && !superClass.isAnnotationPresent(MappedSuperclass.class)) continue;
                copy.add(superClass);
            }
        }
    }

    private void orderHierarchy(List<XClass> copy, List<XClass> newList, List<XClass> original, XClass clazz) {
        if (clazz == null || this.reflectionManager.equals(clazz, Object.class)) {
            return;
        }
        this.orderHierarchy(copy, newList, original, clazz.getSuperclass());
        if (original.contains(clazz)) {
            if (!newList.contains(clazz)) {
                newList.add(clazz);
            }
            copy.remove(clazz);
        }
    }
}

