/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa.binding;

import cn.sexycode.mybatis.jpa.binding.AnnotatedClassType;
import cn.sexycode.mybatis.jpa.binding.EntityBinder;
import cn.sexycode.mybatis.jpa.binding.InheritanceState;
import cn.sexycode.mybatis.jpa.binding.MappingException;
import cn.sexycode.mybatis.jpa.binding.MetadataBuildingContext;
import cn.sexycode.mybatis.jpa.mapping.PersistentClass;
import cn.sexycode.mybatis.jpa.mapping.RootClass;
import cn.sexycode.util.core.cls.XClass;
import cn.sexycode.util.core.cls.XPackage;
import cn.sexycode.util.core.exception.AnnotationException;
import cn.sexycode.util.core.exception.AssertionFailure;
import cn.sexycode.util.core.exception.ClassLoadingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.InheritanceType;
import javax.persistence.MappedSuperclass;
import javax.persistence.SequenceGenerator;
import javax.persistence.SequenceGenerators;
import javax.persistence.TableGenerator;
import javax.persistence.TableGenerators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotationBinder {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindDefaults(MetadataBuildingContext context) {
        Map defaults = context.getReflectionManager().getDefaults();
        List anns = (List)defaults.get(SequenceGenerator.class);
        if (anns != null) {
            for (SequenceGenerator sequenceGenerator : anns) {
            }
        }
        if ((anns = (List)defaults.get(TableGenerator.class)) != null) {
            // empty if block
        }
        if ((anns = (List)defaults.get(TableGenerators.class)) != null) {
            anns.forEach(tableGenerators -> {});
        }
        if ((anns = (List)defaults.get(SequenceGenerators.class)) != null) {
            anns.forEach(sequenceGenerators -> {});
        }
    }

    public static void bindPackage(String packageName, MetadataBuildingContext context) {
        XPackage pckg;
        try {
            pckg = context.getReflectionManager().packageForName(packageName);
        }
        catch (ClassLoadingException e) {
            LOG.warn(packageName);
            return;
        }
        catch (ClassNotFoundException cnf) {
            LOG.warn(packageName);
            return;
        }
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            SequenceGenerator ann = (SequenceGenerator)pckg.getAnnotation(SequenceGenerator.class);
            if (LOG.isTraceEnabled()) {
                // empty if block
            }
        }
        if (pckg.isAnnotationPresent(SequenceGenerators.class)) {
            // empty if block
        }
        if (pckg.isAnnotationPresent(TableGenerator.class)) {
            TableGenerator tableGenerator = (TableGenerator)pckg.getAnnotation(TableGenerator.class);
        }
        if (pckg.isAnnotationPresent(TableGenerators.class)) {
            // empty if block
        }
    }

    public static void bindClass(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, MetadataBuildingContext context) throws MappingException {
        if (clazzToProcess.isAnnotationPresent(Entity.class) && clazzToProcess.isAnnotationPresent(MappedSuperclass.class)) {
            throw new AnnotationException("An entity cannot be annotated with both @Entity and @MappedSuperclass: " + clazzToProcess.getName());
        }
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        if (!AnnotationBinder.isEntityClassType(clazzToProcess, Entity.class)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Binding entity from annotated class: %s", (Object)clazzToProcess.getName());
        }
        PersistentClass persistentClass = AnnotationBinder.makePersistentClass(inheritanceState, null, context);
        Entity entityAnn = (Entity)clazzToProcess.getAnnotation(Entity.class);
        EntityBinder entityBinder = new EntityBinder(entityAnn, clazzToProcess, persistentClass, context);
        entityBinder.setInheritanceState(inheritanceState);
        context.getMetadataCollector().addEntityBinding(persistentClass);
    }

    public static Map<XClass, InheritanceState> buildInheritanceStates(List<XClass> orderedClasses, MetadataBuildingContext buildingContext) {
        HashMap<XClass, InheritanceState> inheritanceStatePerClass = new HashMap<XClass, InheritanceState>(orderedClasses.size());
        for (XClass clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass);
            InheritanceState state = new InheritanceState(clazz, inheritanceStatePerClass, buildingContext);
            if (superclassState != null) {
                boolean nonDefault;
                superclassState.setHasSiblings(true);
                InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazz, inheritanceStatePerClass);
                state.setHasParents(superEntityState != null);
                boolean bl = nonDefault = state.getType() != null && !InheritanceType.SINGLE_TABLE.equals((Object)state.getType());
                if (superclassState.getType() != null) {
                    boolean mixingStrategy;
                    boolean bl2 = mixingStrategy = state.getType() != null && !state.getType().equals((Object)superclassState.getType());
                    if (!nonDefault || mixingStrategy) {
                        // empty if block
                    }
                    state.setType(superclassState.getType());
                }
            }
            inheritanceStatePerClass.put(clazz, state);
        }
        return inheritanceStatePerClass;
    }

    private static PersistentClass makePersistentClass(InheritanceState inheritanceState, PersistentClass superEntity, MetadataBuildingContext metadataBuildingContext) {
        if (!inheritanceState.hasParents()) {
            return new RootClass();
        }
        throw new AssertionFailure("Unknown inheritance type: " + inheritanceState.getType());
    }

    private static boolean isEntityClassType(XClass clazzToProcess, Class classType) {
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals(classType) || AnnotatedClassType.NONE.equals(classType) || AnnotatedClassType.EMBEDDABLE.equals(classType)) {
            if (!AnnotatedClassType.NONE.equals(classType) || clazzToProcess.isAnnotationPresent(Entity.class)) {
                // empty if block
            }
            return false;
        }
        if (!classType.equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have a @javax.persistence.Entity, @javax.persistence.Embeddable or @javax.persistence.EmbeddedSuperclass annotation: " + clazzToProcess.getName());
        }
        return true;
    }
}

