/*
 * Decompiled with CFR 0.152.
 */
package cn.sexycode.mybatis.jpa;

import cn.sexycode.mybatis.jpa.MyBatisConfiguration;
import cn.sexycode.mybatis.jpa.session.SessionFactoryBuilderImpl;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;

public class MybatisPersistenceProvider
implements PersistenceProvider {
    private static final Logger log = Logger.getLogger(MybatisPersistenceProvider.class.getName());
    private SqlSessionFactory sessionFactory;
    private PersistenceUnitInfo persistenceUnitInfo;

    public MybatisPersistenceProvider(SqlSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Starting createEntityManagerFactory for persistenceUnitName %s", persistenceUnitName));
        }
        try {
            if (this.sessionFactory != null) {
                return new SessionFactoryBuilderImpl(this.persistenceUnitInfo, properties).sqlSessionFactory(this.sessionFactory).build((MyBatisConfiguration)this.getConfig(properties));
            }
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)MybatisPersistenceProvider.wrap(properties));
            InputStream configStream = Resources.getResourceAsStream((ClassLoader)ClassLoader.getSystemClassLoader(), (String)"mybatis-config.xml");
            if (configStream != null) {
                return new SessionFactoryBuilderImpl(this.persistenceUnitInfo, properties).build(configStream, prop);
            }
            return new SessionFactoryBuilderImpl(this.persistenceUnitInfo, properties).build((MyBatisConfiguration)this.getConfig(properties));
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to build entity manager factory", e);
            throw new PersistenceException("Unable to build entity manager factory", (Throwable)e);
        }
    }

    private Configuration getConfig(Map properties) {
        return new MyBatisConfiguration();
    }

    protected static Map wrap(Map properties) {
        return properties == null ? Collections.emptyMap() : Collections.unmodifiableMap(properties);
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest(String.format("Starting createContainerEntityManagerFactory : %s", info.getPersistenceUnitName()));
        }
        this.persistenceUnitInfo = info;
        return this.createEntityManagerFactory(info.getPersistenceUnitName(), properties);
    }

    public void generateSchema(PersistenceUnitInfo persistenceUnitInfo, Map map) {
    }

    public boolean generateSchema(String s, Map map) {
        return false;
    }

    public ProviderUtil getProviderUtil() {
        return null;
    }
}

