package cn.schoolwow.workflow.util;

import org.apache.commons.lang3.Validate;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class ReflectionUtil {
    public static List getInstanceSingleFieldValueList(List list, String fieldName) {
        List fieldValueList = new ArrayList();
        for(Object instance:list){
            Object fieldValue = getInstanceFieldValue(instance, fieldName);
            fieldValueList.add(fieldValue);
        }
        return fieldValueList;
    }

    public static List<String> getInstanceFieldValueList(List list, String... fieldNames) {
        List<String> fieldValueList = new ArrayList();
        StringBuilder builder = new StringBuilder();
        for(Object instance:list){
            builder.setLength(0);
            for(String fieldName:fieldNames){
                Object fieldValue = getInstanceFieldValue(instance, fieldName);
                builder.append(fieldValue.toString()+":");
            }
            builder.deleteCharAt(builder.length()-1);
            fieldValueList.add(builder.toString());
        }
        return fieldValueList;
    }

    public static Object getInstanceFilterByFieldValue(List list, String fieldName, Object fieldValue) {
        for(Object instance:list){
            Object actualFieldValue = getInstanceFieldValue(instance, fieldName);
            if(fieldValue.equals(actualFieldValue)){
                return instance;
            }
        }
        return null;
    }

    public static Object getInstanceFieldValue(Object instance, String fieldName) {
        try {
            Field field = searchFieldFromSuperClass(fieldName, instance.getClass());
            Object value = field.get(instance);
            return value;
        }catch (Exception e){
            throw new RuntimeException(e);
        }
    }

    public static Object getInstanceFieldValue(Object instance, String[] fieldNames) {
        Validate.notEmpty(fieldNames, "字段名称列表不能为空");
        try {
            if(fieldNames.length==1){
                Field field = searchFieldFromSuperClass(fieldNames[0], instance.getClass());
                Object value = field.get(instance);
                return value;
            }else{
                StringBuilder builder = new StringBuilder();
                for(String fieldName:fieldNames){
                    Field field = searchFieldFromSuperClass(fieldName, instance.getClass());
                    Object value = field.get(instance);
                    Validate.notNull(value, "实例值查询为空!实例类:"+instance.getClass().getName()+",字段名:"+fieldName);
                    builder.append(value+":");
                }
                builder.deleteCharAt(builder.length()-1);
                return builder.toString();
            }
        }catch (Exception e){
            throw new RuntimeException(e);
        }
    }

    private static Field searchFieldFromSuperClass(String fieldName, Class clazz){
        String initialClassName = clazz.getName();
        while(null!=clazz.getSuperclass()){
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            } catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new IllegalArgumentException("字段不存在!字段名:"+fieldName+",类名:"+initialClassName);
    }
}
