package cn.schoolwow.workflow.util;

import org.apache.commons.lang3.Validate;

import java.util.List;

public class InstanceFilterUtil {
    public static <T> T filterByFieldValue(List<T> list, String fieldName, Object fieldValue) {
        for(T instance:list){
            Object actualFieldValue = ReflectionUtil.getInstanceFieldValue(instance, fieldName);
            if(fieldValue.equals(actualFieldValue)){
                return instance;
            }
        }
        return null;
    }

    public static <T> T filterByMultipleFieldValue(List<T> list, String[] fieldNames, Object[] fieldValues) {
        Validate.isTrue(fieldNames.length==fieldValues.length, "字段名和字段值列表长度不一致!字段名长度:"+fieldNames.length+",字段值长度:"+fieldValues.length);
        for(T instance:list){
            boolean match = true;
            for(int i=0;i<fieldNames.length;i++){
                Object actualFieldValue = ReflectionUtil.getInstanceFieldValue(instance, fieldNames[i]);
                match = match && fieldValues[i].equals(actualFieldValue);
            }
            if(match){
                return instance;
            }
        }
        return null;
    }

}
