package cn.schoolwow.workflow.module.task.service;

import cn.schoolwow.quickflow.QuickFlowExecutor;
import cn.schoolwow.quickflow.flow.CompositeBusinessFlow;
import cn.schoolwow.workflow.module.parent.flow.InsertWorkFlowTaskFlow;
import cn.schoolwow.workflow.module.parent.handler.TransactionTryCatchFinallyHandler;
import cn.schoolwow.workflow.module.task.flow.complete.*;
import cn.schoolwow.workflow.module.task.flow.listener.ExecuteAfterCompleteTaskListenerFlow;
import cn.schoolwow.workflow.module.task.flow.listener.ExecuteAfterTaskCreateListenerFlow;
import cn.schoolwow.workflow.module.task.flow.listener.ExecuteBeforeCompleteTaskListenerFlow;

public class CompleteTaskCompositeBusiness implements CompositeBusinessFlow {
    @Override
    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
        quickFlowExecutor.next(new CheckCompleteTaskRequestFlow())
                .next(new QueryTaskNextNodeFlow())
                .next(new ExecuteBeforeCompleteTaskListenerFlow())
                .next(new CompositeBusinessFlow() {
                    @Override
                    public void executeCompositeBusiness(QuickFlowExecutor quickFlowExecutor) {
                        quickFlowExecutor.tryCatchFinallyHandler(new TransactionTryCatchFinallyHandler())
                                .next(new UpdateWorkFlowTaskStatusFlow())
                                .next(new UpdateWorkFlowInstanceFlow())
                                .next(new InsertWorkFlowTaskFlow())
                                .next(new AddWorkFlowHistoryFlow());
                    }

                    @Override
                    public String name() {
                        return "完成流程任务-更新数据库记录";
                    }
                })
                .next(new ExecuteAfterTaskCreateListenerFlow())
                .next(new ExecuteAfterCompleteTaskListenerFlow());
    }

    @Override
    public String name() {
        return "完成工作流实例任务";
    }
}
