package cn.schoolwow.workflow.module.task.kit;

import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.workflow.domain.task.CompleteTaskRequest;
import cn.schoolwow.workflow.domain.task.TaskType;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskQuery;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskResponse;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowConfig;
import cn.schoolwow.workflow.module.task.service.CompleteTaskCompositeBusiness;
import cn.schoolwow.workflow.module.task.service.GetPagingTaskListCompositeBusiness;
import cn.schoolwow.workflow.module.task.service.GetTaskListCompositeBusiness;

import java.util.List;

public class WorkFlowTaskServiceImpl implements WorkFlowTaskService{
    private QuickWorkFlowConfig quickWorkFlowConfig;

    public WorkFlowTaskServiceImpl(QuickWorkFlowConfig quickWorkFlowConfig) {
        this.quickWorkFlowConfig = quickWorkFlowConfig;
    }

    @Override
    public WorkFlowTaskResponse getSingleTask(WorkFlowTaskQuery workFlowTaskQuery){
        PageVo<WorkFlowTaskResponse> pageVo = getPagingTaskList(workFlowTaskQuery,1,100);
        if(null==pageVo||null==pageVo.getList()||pageVo.getList().isEmpty()){
            return null;
        }
        if(pageVo.getTotalSize()>1){
            throw new IllegalArgumentException("期望获取单个分配任务，但是实际任务个数大于1!实际任务个数:"+pageVo.getTotalSize());
        }
        return pageVo.getList().get(0);
    }

    @Override
    public List<WorkFlowTaskResponse> getTaskList(WorkFlowTaskQuery workFlowTaskQuery) {
        FlowContext flowContext = quickWorkFlowConfig.workflow.startFlow(new GetTaskListCompositeBusiness())
                .putCurrentCompositeFlowData("workFlowTaskQuery", workFlowTaskQuery)
                .execute();
        List<WorkFlowTaskResponse> list = (List<WorkFlowTaskResponse>) flowContext.getData("list");
        return list;
    }

    @Override
    public PageVo<WorkFlowTaskResponse> getPagingTaskList(WorkFlowTaskQuery workFlowTaskQuery, int pageNumber, int pageSize){
        FlowContext flowContext = quickWorkFlowConfig.workflow.startFlow(new GetPagingTaskListCompositeBusiness())
                .putCurrentCompositeFlowData("workFlowTaskQuery", workFlowTaskQuery)
                .putCurrentCompositeFlowData("pageNumber", pageNumber)
                .putCurrentCompositeFlowData("pageSize", pageSize)
                .execute();
        PageVo<WorkFlowTaskResponse> pageVo = (PageVo<WorkFlowTaskResponse>) flowContext.checkData("pageVo");
        return pageVo;
    }

    @Override
    public boolean completeTask(long taskId, TaskType taskType) {
        CompleteTaskRequest completeTaskRequest = new CompleteTaskRequest();
        completeTaskRequest.taskId = taskId;
        completeTaskRequest.taskType = taskType;
        return completeTask(completeTaskRequest);
    }

    @Override
    public boolean completeTask(CompleteTaskRequest completeTaskRequest) {
        FlowContext flowContext = quickWorkFlowConfig.workflow.startFlow(new CompleteTaskCompositeBusiness())
                .putCurrentCompositeFlowData("completeTaskRequest", completeTaskRequest)
                .execute();
        boolean instanceFinished = (boolean) flowContext.getData("instanceFinished", false);
        return instanceFinished;
    }

}
