package cn.schoolwow.workflow.module.task.kit;

import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.workflow.domain.task.CompleteTaskRequest;
import cn.schoolwow.workflow.domain.task.TaskType;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskQuery;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskResponse;

import java.util.List;

public interface WorkFlowTaskService {
    /**
     * 查询单个待办任务列表
     * @param workFlowTaskQuery 任务查询请求
     * */
    WorkFlowTaskResponse getSingleTask(WorkFlowTaskQuery workFlowTaskQuery);

    /**
     * 分页查询任务列表
     * @param workFlowTaskQuery 任务查询请求
     * */
    List<WorkFlowTaskResponse> getTaskList(WorkFlowTaskQuery workFlowTaskQuery);

    /**
     * 分页查询任务列表
     * @param workFlowTaskQuery 任务查询请求
     * @param pageNumber 页码
     * @param pageSize 每页个数
     * */
    PageVo<WorkFlowTaskResponse> getPagingTaskList(WorkFlowTaskQuery workFlowTaskQuery, int pageNumber, int pageSize);

    /**
     * 完成任务
     * @param taskId 任务id
     * @param taskType 完成任务类型
     * @return 实例是否结束
     * */
    boolean completeTask(long taskId, TaskType taskType);

    /**
     * 完成任务
     * @param completeTaskRequest 完成任务请求
     * @return 实例是否结束
     * */
    boolean completeTask(CompleteTaskRequest completeTaskRequest);
}
