package cn.schoolwow.workflow.module.task.flow.query;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.database.dql.subCondition.SubCondition;
import cn.schoolwow.quickdao.domain.provider.DatabaseProvider;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskQuery;
import cn.schoolwow.workflow.entity.WorkFlowDefinition;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.entity.WorkFlowNode;
import cn.schoolwow.workflow.entity.WorkFlowTask;
import org.apache.commons.lang3.StringUtils;

import java.util.Set;

public class SetTaskQueryConditionFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setCondition(flowContext);
        addConditionQuery(flowContext);
    }

    @Override
    public String name() {
        return "设置工作流任务查询对象";
    }

    private void setCondition(FlowContext flowContext){
        DAO dao = (DAO) flowContext.checkData("dao");
        DatabaseProvider databaseProvider = dao.getDatabaseProvider();

        Condition condition = dao.query(WorkFlowTask.class)
                .orderByDesc("createdAt")
                .addColumn("id " + databaseProvider.escape("taskId"))
                .addColumn("complete " + databaseProvider.escape("complete"));
        flowContext.putTemporaryData("condition", condition);

        //关联工作流实例
        SubCondition workFlowInstanceSubCondition = condition.joinTable(WorkFlowInstance.class, "instanceId", "id")
                .addColumn("id " + databaseProvider.escape("instanceId"))
                .addColumn("definitionId " + databaseProvider.escape("definitionId"))
                .addColumn("initiator " + databaseProvider.escape("initiator"))
                .addColumn("contextData " + databaseProvider.escape("contextData"));
        flowContext.putTemporaryData("workFlowInstanceSubCondition", workFlowInstanceSubCondition);

        //关联流程定义
        SubCondition workFlowDefinitionSubCondition = workFlowInstanceSubCondition.joinTable(WorkFlowDefinition.class, "definitionId", "id")
                .addColumn("name " + databaseProvider.escape("definitionName"));
        flowContext.putTemporaryData("workFlowDefinitionSubCondition", workFlowDefinitionSubCondition);

        //关联节点名称
        SubCondition workFlowNodeSubCondition = condition.joinTable(WorkFlowNode.class, "nodeId", "id")
                .addColumn("name "+dao.getDatabaseProvider().escape("taskName"));
        flowContext.putTemporaryData("workFlowNodeSubCondition", workFlowNodeSubCondition);
    }

    private void addConditionQuery(FlowContext flowContext){
        WorkFlowTaskQuery workFlowTaskQuery = (WorkFlowTaskQuery) flowContext.checkData("workFlowTaskQuery");
        {
            Condition condition = (Condition) flowContext.checkData("condition");
            if(null!=workFlowTaskQuery.workFlowTaskIdList&&!workFlowTaskQuery.workFlowTaskIdList.isEmpty()){
                condition.addInQuery("id", workFlowTaskQuery.workFlowTaskIdList);
            }
            if(null!=workFlowTaskQuery.workFlowInstanceIdList&&!workFlowTaskQuery.workFlowInstanceIdList.isEmpty()){
                condition.addInQuery("instanceId", workFlowTaskQuery.workFlowInstanceIdList);
            }
            if(StringUtils.isNotBlank(workFlowTaskQuery.assigner)){
                condition.addQuery("assigner", workFlowTaskQuery.assigner);
            }
            if(null!=workFlowTaskQuery.complete){
                condition.addQuery("complete", workFlowTaskQuery.complete);
            }
        }
        {
            SubCondition workFlowInstanceSubCondition = (SubCondition) flowContext.checkData("workFlowInstanceSubCondition");
            if(null!=workFlowTaskQuery.instanceFinished){
                workFlowInstanceSubCondition.addQuery("finished", workFlowTaskQuery.instanceFinished);
            }
            if(null!=workFlowTaskQuery.initiator){
                workFlowInstanceSubCondition.addQuery("initiator", workFlowTaskQuery.initiator);
            }
            Set<String> keySet = workFlowTaskQuery.contextDataQuery.keySet();
            for(String key:keySet){
                String value = workFlowTaskQuery.contextDataQuery.getString(key);
                workFlowInstanceSubCondition.addRawQuery("t1.context_data->'"+key+"' = ?", value);
            }
        }
        {
            SubCondition workFlowDefinitionSubCondition = (SubCondition) flowContext.checkData("workFlowDefinitionSubCondition");
            if(StringUtils.isNotBlank(workFlowTaskQuery.definitionName)){
                workFlowDefinitionSubCondition.addQuery("name", workFlowTaskQuery.definitionName);
            }
        }
        {
            SubCondition workFlowNodeSubCondition = (SubCondition) flowContext.checkData("workFlowNodeSubCondition");
            if(StringUtils.isNotBlank(workFlowTaskQuery.nodeName)){
                workFlowNodeSubCondition.addQuery("name", workFlowTaskQuery.nodeName);
            }
        }
    }
}
