package cn.schoolwow.workflow.module.task.flow.query;

import cn.schoolwow.quickdao.domain.database.dql.condition.Condition;
import cn.schoolwow.quickdao.domain.database.dql.response.PageVo;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskResponse;

public class GetTaskPagingListFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        int pageNumber = (int) flowContext.getData("pageNumber", 1);
        int pageSize = (int) flowContext.getData("pageSize", 10);
        Condition condition = (Condition) flowContext.checkData("condition");

        PageVo<WorkFlowTaskResponse> pageVo = condition.page(pageNumber, pageSize)
                .execute()
                .getPagingList(WorkFlowTaskResponse.class);
        flowContext.putTemporaryData("pageVo", pageVo);
    }

    @Override
    public String name() {
        return "分页查询任务列表";
    }

}
