package cn.schoolwow.workflow.module.task.flow.listener;

import cn.schoolwow.quickdao.domain.DAO;
import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.CompleteTaskRequest;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskResponse;
import cn.schoolwow.workflow.entity.WorkFlowDefinition;
import cn.schoolwow.workflow.entity.WorkFlowInstance;
import cn.schoolwow.workflow.entity.WorkFlowNode;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowOption;

public class ExecuteBeforeCompleteTaskListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        setDefinitionName(flowContext);
        checkListenerExist(flowContext);
        executeListener(flowContext);
    }

    @Override
    public String name() {
        return "执行工作流任务完成之前事件";
    }

    private void setDefinitionName(FlowContext flowContext){
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");

        DAO dao = (DAO) flowContext.checkData("dao");
        String definitionName = dao.query(WorkFlowDefinition.class)
                .addQuery("id", workFlowInstance.getDefinitionId())
                .addColumn("name")
                .execute()
                .getSingleColumn(String.class);
        flowContext.putTemporaryData("definitionName", definitionName);
    }

    private void checkListenerExist(FlowContext flowContext){
        QuickWorkFlowOption quickWorkFlowOption = (QuickWorkFlowOption) flowContext.checkData("quickWorkFlowOption");

        if(null==quickWorkFlowOption.workFlowTaskListener){
            flowContext.brokenCurrentFlow("工作流任务监听器不存在!");
        }
    }

    private void executeListener(FlowContext flowContext){
        QuickWorkFlowOption quickWorkFlowOption = (QuickWorkFlowOption) flowContext.checkData("quickWorkFlowOption");
        WorkFlowInstance workFlowInstance = (WorkFlowInstance) flowContext.checkData("workFlowInstance");
        CompleteTaskRequest completeTaskRequest = (CompleteTaskRequest) flowContext.checkData("completeTaskRequest");
        WorkFlowNode currentWorkflowNode = (WorkFlowNode) flowContext.checkData("currentWorkflowNode");
        String definitionName = (String) flowContext.checkData("definitionName");

        WorkFlowTaskResponse beforeWorkFlowTaskResponse = new WorkFlowTaskResponse();
        beforeWorkFlowTaskResponse.instanceId = workFlowInstance.getId();
        beforeWorkFlowTaskResponse.definitionId = workFlowInstance.getDefinitionId();
        beforeWorkFlowTaskResponse.definitionName = definitionName;
        beforeWorkFlowTaskResponse.taskId = completeTaskRequest.taskId;
        beforeWorkFlowTaskResponse.taskName = currentWorkflowNode.getName();
        beforeWorkFlowTaskResponse.contextData = workFlowInstance.getContextData();
        beforeWorkFlowTaskResponse.complete = false;

        quickWorkFlowOption.workFlowTaskListener.beforeTaskComplete(beforeWorkFlowTaskResponse);
        flowContext.putTemporaryData("beforeWorkFlowTaskResponse", beforeWorkFlowTaskResponse);
    }
}
