package cn.schoolwow.workflow.module.task.flow.listener;

import cn.schoolwow.quickflow.domain.FlowContext;
import cn.schoolwow.quickflow.flow.BusinessFlow;
import cn.schoolwow.workflow.domain.task.WorkFlowTaskResponse;
import cn.schoolwow.workflow.module.parent.domain.QuickWorkFlowOption;

public class ExecuteAfterTaskCreateListenerFlow implements BusinessFlow {
    @Override
    public void executeBusinessFlow(FlowContext flowContext) throws Exception {
        QuickWorkFlowOption quickWorkFlowOption = (QuickWorkFlowOption) flowContext.checkData("quickWorkFlowOption");

        if(null==quickWorkFlowOption.workFlowTaskListener){
            return;
        }
        WorkFlowTaskResponse workFlowTaskResponse = (WorkFlowTaskResponse) flowContext.getData("workFlowTaskResponse");
        //如果不是中间节点，则没有任务创建
        if(null!=workFlowTaskResponse){
            quickWorkFlowOption.workFlowTaskListener.afterTaskCreate(workFlowTaskResponse);
        }
    }

    @Override
    public String name() {
        return "执行工作流任务创建之后事件";
    }
}
